/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.errors;

import apex.jorje.data.errors.SyntaxError;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;

public class SyntaxErrorPrinter
implements Printer<SyntaxError> {
    private static final SyntaxErrorPrinter INSTANCE = new SyntaxErrorPrinter();
    private static final SyntaxError.MatchBlock<String> MATCHER = new SyntaxError.MatchBlock<String>(){

        @Override
        public String _case(SyntaxError.MismatchedSyntax x) {
            return I18nSupport.getLabel("mismatched.syntax", x.actual, x.expected);
        }

        @Override
        public String _case(SyntaxError.MissingSyntax x) {
            return I18nSupport.getLabel("missing.syntax", x.actual, x.expected);
        }

        @Override
        public String _case(SyntaxError.UnmatchedSyntax x) {
            return I18nSupport.getLabel("unmatched.syntax", x.actual, x.expected);
        }

        @Override
        public String _case(SyntaxError.UnexpectedSyntaxError x) {
            return I18nSupport.getLabel("unexpected.syntax.error", x.message);
        }

        @Override
        public String _case(SyntaxError.UnexpectedToken x) {
            return I18nSupport.getLabel("unexpected.token", x.token);
        }

        @Override
        public String _case(SyntaxError.UnexpectedEof x) {
            return I18nSupport.getLabel("unexpected.eof");
        }

        @Override
        public String _case(SyntaxError.IllegalStringLiteral x) {
            return I18nSupport.getLabel("illegal.string.literal", x.message);
        }

        @Override
        public String _case(SyntaxError.IllegalIntegerLiteral x) {
            return I18nSupport.getLabel("illegal.integer.literal");
        }

        @Override
        public String _case(SyntaxError.IllegalLongLiteral x) {
            return I18nSupport.getLabel("illegal.long.literal");
        }

        @Override
        public String _case(SyntaxError.IllegalDoubleLiteral x) {
            return I18nSupport.getLabel("illegal.double.literal");
        }

        @Override
        public String _case(SyntaxError.IllegalDecimalLiteral x) {
            return I18nSupport.getLabel("illegal.decimal.literal");
        }
    };

    private SyntaxErrorPrinter() {
    }

    public static Printer<SyntaxError> get() {
        return INSTANCE;
    }

    @Override
    public String print(SyntaxError x, PrintContext ctx) {
        return x.match(MATCHER);
    }
}

