/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.Identifier;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.List;
import java.util.Optional;

public class ClassDeclPrinter
implements Printer<ClassDecl> {
    private final String indent;
    private final PrinterFactory factory;
    private final Printer<List<Modifier>> modifiersPrinter;
    private final Printer<Optional<List<Identifier>>> typeArgumentsPrinter;
    private final Printer<Identifier> identifierPrinter;
    private final Printer<Optional<TypeRef>> optionalSuperClassPrinter;
    private final Printer<List<TypeRef>> listInterfacePrinter;

    public ClassDeclPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.indent = factory.indent();
        this.modifiersPrinter = factory.modifiersPrinter();
        this.typeArgumentsPrinter = factory.optionalIdentifiersPrinter();
        this.identifierPrinter = factory.identifierPrinter();
        this.optionalSuperClassPrinter = OptionalPrinter.create(factory.typeRefPrinter(), "", " extends ", "");
        this.listInterfacePrinter = ListPrinter.create(factory.typeRefPrinter(), ", ", " implements ", "");
    }

    @Override
    public String print(ClassDecl x, PrintContext ctx) {
        StringBuilder builder = new StringBuilder(this.indent);
        builder.append(this.modifiersPrinter.print(x.modifiers, ctx));
        builder.append("class");
        builder.append(" ");
        builder.append(this.identifierPrinter.print(x.name, ctx));
        builder.append(this.typeArgumentsPrinter.print(x.typeArguments, ctx));
        builder.append(this.optionalSuperClassPrinter.print(x.superClass, ctx));
        builder.append(this.listInterfacePrinter.print(x.interfaces, ctx));
        builder.append(" {\n");
        Printer<List<BlockMember>> listMemberPrinter = ListPrinter.create(this.factory.nestedPrinterFactory().blockMemberPrinter(), "\n\n", "", "\n");
        builder.append(listMemberPrinter.print(x.members, ctx));
        builder.append(this.indent);
        builder.append("}");
        return builder.toString();
    }
}

