/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.exception;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.errors.UserError;
import apex.jorje.services.exception.CompilationException;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterUtil;

public class ParseException
extends CompilationException {
    private static final long serialVersionUID = -6570546605373595223L;
    private final UserError error;
    private final String message;

    private ParseException(UserError error, Throwable cause) {
        super(error.toString(), cause);
        this.error = error;
        this.message = PrinterUtil.get().getFactory().userErrorPrinter().print(error, PrintContexts.empty());
    }

    public static ParseException create(UserError error, Throwable cause) {
        return new ParseException(error, cause);
    }

    public UserError getUserError() {
        return this.error;
    }

    @Override
    public Location getLoc() {
        return Locations.from(this.error);
    }

    @Override
    public String getError() {
        return this.message;
    }
}

