/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility.legacy.loopholes;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.symbol.visibility.legacy.loopholes.PropertyLoophole;
import apex.jorje.services.Version;

public class PrivateSetterVisible
implements PropertyLoophole {
    private static final PrivateSetterVisible INSTANCE = new PrivateSetterVisible();
    private static final AstVisitor<BooleanScope> IS_PREFIX_OR_POSTFIX_EXPRESSION = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(PostfixExpression node, BooleanScope scope) {
            scope.setValue(true);
        }

        @Override
        public void visitEnd(PrefixExpression node, BooleanScope scope) {
            scope.setValue(node.getOp().isIncOrDec());
        }
    };
    private static final AstVisitor<BooleanScope> IS_IN_PREFIX_OR_POSTFIX_EXPRESSION = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(VariableExpression node, BooleanScope scope) {
            node.getDefiningNode().traverse(IS_PREFIX_OR_POSTFIX_EXPRESSION, scope);
        }
    };

    private PrivateSetterVisible() {
    }

    private static boolean isInPrefixOrPostfixExpression(AstNode node) {
        return BooleanScope.evaluate(node, IS_IN_PREFIX_OR_POSTFIX_EXPRESSION, false);
    }

    public static PrivateSetterVisible get() {
        return INSTANCE;
    }

    @Override
    public boolean isApplicableForCheckType(Visibility.CheckType checkType) {
        return checkType == Visibility.CheckType.CALLER_WRITE;
    }

    @Override
    public boolean isApplicableForDefiningTypeVersion(Version propertyDefiningVersion) {
        return true;
    }

    @Override
    public boolean isApplicableForReferencingTypeVersion(Version referencingVersion) {
        return true;
    }

    @Override
    public boolean isVisibleThroughLoophole(AccessEvaluator accessEvaluator, Variable property, AstNode referencingNode, Visibility.ReferencedFromTestMethod referencedFromTestMethod) {
        return PrivateSetterVisible.isInPrefixOrPostfixExpression(referencingNode) && Visibility.isMemberVariableVisible(accessEvaluator, referencingNode.getDefiningType(), property, referencedFromTestMethod, Visibility.CheckType.CALLER_READ);
    }
}

