/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.services.I18nSupport;

public class JsonAccessContextRule
implements AnnotationContextRule {
    private static final JsonAccessContextRule INSTANCE = new JsonAccessContextRule();

    private JsonAccessContextRule() {
    }

    public static JsonAccessContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
    }

    @Override
    public void validate(FieldContext context) {
    }

    @Override
    public void validate(TypeContext context) {
        ModifierOrAnnotation annotation = context.getModifiers().get(AnnotationTypeInfos.JSON_ACCESS);
        AnnotationParameter serializationAllowedParameter = annotation.getParameter(AnnotationTypeInfos.JsonSerializationControlParameter.SERIALIZABLE.getParameterName());
        AnnotationParameter deserializationAllowedParameter = annotation.getParameter(AnnotationTypeInfos.JsonSerializationControlParameter.DESERIALIZABLE.getParameterName());
        if (serializationAllowedParameter == null && deserializationAllowedParameter == null) {
            context.addNodeError(I18nSupport.getLabel("annotation.jsonaccess.must.specify.control.parameter"));
        }
    }
}

