/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.common.base.Result;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Collection;

public interface FieldTable {
    public static final Initializer<FieldTable, TypeInfo> EMPTY = Initializers.ofInstance(new StandardFieldTable().resolve());

    public Result<Void> add(FieldInfo var1);

    public FieldInfo get(SymbolResolver var1, TypeInfo var2, String var3, LookupMode var4);

    public FieldTable resolve();

    public boolean isResolved();

    public Collection<FieldInfo> all();

    public static enum LookupMode {
        STATIC_REFERENCE(true, false, false),
        STATIC_REFERENCE_LOCALS_OKAY(true, false, true),
        INSTANCE_REFERENCE(false, false, false),
        INSTANCE_REFERENCE_LOCALS_OKAY(false, false, true),
        STATIC_VARIABLE(true, true, false),
        STATIC_VARIABLE_LOCALS_OKAY(true, true, true),
        INSTANCE_VARIABLE(false, true, false),
        INSTANCE_VARIABLE_LOCALS_OKAY(false, true, true);

        private final boolean staticsFirst;
        private final boolean isLast;
        private final boolean localsAllowed;

        private LookupMode(boolean staticsFirst, boolean isLast, boolean localsAllowed) {
            this.staticsFirst = staticsFirst;
            this.isLast = isLast;
            this.localsAllowed = localsAllowed;
        }

        public static LookupMode switchToStatic(LookupMode mode) {
            switch (mode) {
                case STATIC_REFERENCE: 
                case INSTANCE_REFERENCE: {
                    return STATIC_REFERENCE;
                }
                case STATIC_REFERENCE_LOCALS_OKAY: 
                case INSTANCE_REFERENCE_LOCALS_OKAY: {
                    return STATIC_REFERENCE_LOCALS_OKAY;
                }
                case STATIC_VARIABLE: 
                case INSTANCE_VARIABLE: {
                    return STATIC_VARIABLE;
                }
                case STATIC_VARIABLE_LOCALS_OKAY: 
                case INSTANCE_VARIABLE_LOCALS_OKAY: {
                    return STATIC_VARIABLE_LOCALS_OKAY;
                }
            }
            throw new UnsupportedOperationException("unknown mode: " + (Object)((Object)mode));
        }

        public boolean areStaticsFirst() {
            return this.staticsFirst;
        }

        public boolean isLast() {
            return this.isLast;
        }

        public boolean areLocalsAllowed() {
            return this.localsAllowed;
        }
    }
}

