/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.bcl.VfComponentEmitMethods;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldTable;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import com.google.common.base.Strings;

public final class DynamicFieldTables {
    private DynamicFieldTables() {
    }

    public static DynamicFieldTable createFacetsTable(VfComponentTypeInfo type) {
        return new DynamicFieldTable((symbols, referencingType, name) -> {
            if (type.hasFacet(name)) {
                return ((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setDefiningType(type)).setType(InternalTypeInfos.APEX_PAGES_COMPONENT)).setModifiers(ModifierGroups.ONLY_GLOBAL)).setName(name.toLowerCase())).setLoadEmitter((emitter, info, context) -> {
                    emitter.push(context.loc, info.getName());
                    emitter.emit(context.loc, VfComponentEmitMethods.getFacet(info.getDefiningType()));
                }).setStoreEmitter((emitter, info, context) -> {
                    emitter.emit(context.loc, 95);
                    emitter.push(context.loc, info.getName());
                    emitter.emit(context.loc, VfComponentEmitMethods.setFacet(info.getDefiningType()));
                }).build();
            }
            return null;
        });
    }

    public static DynamicFieldTable createExpressionsTable(VfComponentTypeInfo type) {
        return new DynamicFieldTable((symbols, referencingType, name) -> {
            FieldInfo field = type.fields().get(symbols, referencingType, name, FieldTable.LookupMode.INSTANCE_VARIABLE);
            if (field instanceof DynamicFieldInfo) {
                DynamicFieldInfo dynamicField = (DynamicFieldInfo)field;
                if (!dynamicField.isAllowedInVfExpressions()) {
                    return null;
                }
                return ((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setDefiningType(type)).setType(TypeInfos.STRING)).setModifiers(field.getModifiers())).setName(field.getName())).setLoadEmitter((emitter, info, context) -> {
                    emitter.push(context.loc, info.getName());
                    emitter.emit(context.loc, VfComponentEmitMethods.getExpression(info.getDefiningType()));
                }).setStoreEmitter((emitter, info, context) -> {
                    emitter.emit(context.loc, 95);
                    emitter.push(context.loc, info.getName());
                    emitter.emit(context.loc, VfComponentEmitMethods.setExpression(info.getDefiningType()));
                }).build();
            }
            return null;
        });
    }

    public static Initializer<FieldTable, TypeInfo> createLabelTable(Namespace namespace) {
        return Initializers.memoize(type -> new DynamicFieldTable((symbols, referencingType, name) -> {
            if (symbols.getSymbolProvider().hasLabelField(referencingType, namespace, name)) {
                return ((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setDefiningType((TypeInfo)type)).setType(TypeInfos.STRING)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setNamespace(Namespace.isEmptyOrNull(namespace) ? referencingType.getNamespace() : namespace).setName(name)).setLoadEmitter((emitter, info, context) -> {
                    emitter.push(context.loc, info.getNamespace().getNameLower());
                    emitter.push(context.loc, info.getName().toLowerCase());
                    emitter.emit(context.loc, SystemEmitMethods.GET_EXTERNAL_LABEL);
                }).build();
            }
            return null;
        }));
    }

    public static DynamicFieldTable createPageTable() {
        return new DynamicFieldTable((symbols, referencingType, name) -> {
            String pageReference = symbols.getSymbolProvider().getPageReference(referencingType, name);
            if (!Strings.isNullOrEmpty(pageReference)) {
                TypeInfo pageReferenceType = symbols.lookupTypeInfo(referencingType, InternalTypeInfos.SYSTEM_PAGE_REFERENCE);
                return ((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setDefiningType(symbols.getPageTypeInfo())).setType(pageReferenceType)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setName(pageReference)).setLoadEmitter((emitter, info, context) -> {
                    emitter.emitType(context.loc, 187, info.getType());
                    emitter.emit(context.loc, 89);
                    emitter.push(context.loc, info.getName());
                    emitter.emit(context.loc, ObjectEmitMethods.constructor(info.getType(), TypeInfos.STRING));
                }).build();
            }
            return null;
        });
    }
}

