/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method.signature;

import apex.common.base.MoreStrings;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import com.google.common.base.Equivalence;
import java.util.List;
import javax.annotation.Nonnull;

public class SignatureEquivalence
extends Equivalence<Signature> {
    private static final SignatureEquivalence INSTANCE = new SignatureEquivalence();

    public static SignatureEquivalence get() {
        return INSTANCE;
    }

    public static boolean isEquivalent(String name, List<TypeInfo> parameterTypes, String otherName, List<TypeInfo> otherParameterTypes) {
        if (!MoreStrings.equalsIgnoreCase(name, otherName)) {
            return false;
        }
        if (parameterTypes.size() != otherParameterTypes.size()) {
            return false;
        }
        int size = parameterTypes.size();
        for (int i = 0; i < size; ++i) {
            TypeInfo rightType;
            TypeInfo leftType = GenericTypeInfoUtil.getRootTypeIfNotCollection(parameterTypes.get(i));
            if (TypeInfoEquivalence.isEquivalent(leftType, rightType = GenericTypeInfoUtil.getRootTypeIfNotCollection(otherParameterTypes.get(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquivalent(Signature left, Signature right) {
        return SignatureEquivalence.isEquivalent(left.getName(), left.getParameterTypes(), right.getName(), right.getParameterTypes());
    }

    @Override
    protected boolean doEquivalent(@Nonnull Signature left, @Nonnull Signature right) {
        return SignatureEquivalence.isEquivalent(left, right);
    }

    @Override
    protected int doHash(@Nonnull Signature signature) {
        return MoreStrings.lowerCaseHashCode(signature.getName());
    }

    public String toString() {
        return "eq";
    }
}

