/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

public class ValidationSettings {
    private static final ValidationSettings SERVER_COMPILE = ValidationSettings.builder().setValidationBehavior(ValidationBehavior.BREAK_ON_FIRST_ERROR).build();
    private final ValidationBehavior validationBehavior;

    private ValidationSettings(Builder builder) {
        this.validationBehavior = builder.validationBehavior;
    }

    public static ValidationSettings getServerCompileSettings() {
        return SERVER_COMPILE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ValidationBehavior getValidationBehavior() {
        return this.validationBehavior;
    }

    public static class Builder {
        private ValidationBehavior validationBehavior = ValidationBehavior.BREAK_ON_FIRST_ERROR;

        private Builder() {
        }

        public ValidationSettings build() {
            return new ValidationSettings(this);
        }

        public Builder setValidationBehavior(ValidationBehavior validationBehavior) {
            this.validationBehavior = validationBehavior;
            return this;
        }
    }

    public static enum ValidationBehavior {
        COLLECT_MULTIPLE_ERRORS,
        BREAK_ON_FIRST_ERROR;

    }
}

