/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl;

import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.signature.EmitSignatureFactory;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;

public class AsmMethod {
    public static final String STATIC_INIT = "<clinit>";
    public static final String INIT = "<init>";
    public static final int INVOKE_BOOTSTRAP = -1;
    public final int opcode;
    public final String definingType;
    public final String function;
    public final Signature signature;
    public final boolean definerInterface;

    private AsmMethod(Builder builder) {
        this.opcode = builder.opcode;
        this.definingType = builder.definingType;
        this.function = builder.function;
        this.signature = builder.signature;
        this.definerInterface = builder.definerInterface;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("opcode", this.opcode).add("definingType", this.definingType).add("function", this.function).add("signature", this.signature).toString();
    }

    public static class Builder {
        private int opcode;
        private String definingType;
        private String function;
        private Signature signature;
        private boolean definerInterface = false;

        private Builder() {
        }

        public Builder setDefiningTypeAsBytecodeMethodName(TypeInfo definingType) {
            this.definingType = definingType.getBytecodeMethodName();
            this.updateInvocationIfInterface(definingType);
            return this;
        }

        public Builder setDefiningTypeAsBytecodeName(TypeInfo definingType) {
            this.definingType = definingType.getBytecodeName();
            this.updateInvocationIfInterface(definingType);
            return this;
        }

        public Builder setDefiningTypeName(String definingType) {
            this.definingType = definingType;
            return this;
        }

        private void updateInvocationIfInterface(TypeInfo definingType) {
            if (definingType.getUnitType() == UnitType.INTERFACE && definingType.getBasicType() != BasicType.JAVA && this.opcode != -1) {
                this.invokeInterface();
            }
        }

        public Builder setFunction(String function) {
            this.function = function;
            return this;
        }

        public Builder setSignature(TypeInfo returnType, TypeInfo paramTypes) {
            return this.setSignature(returnType, ImmutableList.of(paramTypes));
        }

        public Builder setSignature(TypeInfo returnType) {
            return this.setSignature(returnType, ImmutableList.of());
        }

        public Builder setSignature(TypeInfo returnType, TypeInfo ... paramTypes) {
            return this.setSignature(returnType, MoreLists.asImmutableList(paramTypes));
        }

        public Builder setSignature(TypeInfo returnType, List<TypeInfo> paramTypes) {
            this.signature = EmitSignatureFactory.create(returnType, paramTypes);
            return this;
        }

        public Builder setSignature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public Builder setOpcode(int opcode) {
            this.opcode = opcode;
            return this;
        }

        public Builder invoke(InvocationType invocationType) {
            Builder builder = AsmMethod.builder();
            switch (invocationType) {
                case STATIC: {
                    return builder.invokeStatic();
                }
                case VIRTUAL: {
                    return builder.invokeVirtual();
                }
                case SPECIAL: {
                    return builder.invokeSpecial();
                }
                case BOOTSTRAP: {
                    return builder.invokeBootstrap();
                }
            }
            throw new UnsupportedOperationException("invalid invocationType: " + (Object)((Object)invocationType));
        }

        public Builder invokeVirtual() {
            return this.setOpcode(182);
        }

        public Builder invokeStatic() {
            return this.setOpcode(184);
        }

        public Builder invokeSpecial() {
            return this.setOpcode(183);
        }

        public Builder invokeInterface() {
            this.definerInterface = true;
            return this.setOpcode(185);
        }

        public Builder invokeBootstrap() {
            return this.setOpcode(-1);
        }

        public AsmMethod build() {
            assert (this.opcode != 0);
            assert (this.definingType != null);
            assert (this.function != null);
            assert (this.signature != null);
            return new AsmMethod(this);
        }
    }
}

