/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.common.collect.MoreIterables;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.CatchBlock;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TryCatchFinallyStack;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.Label;

public class TryCatchFinallyBlockStatement
extends Statement {
    static final Emit UNCATCHABLE_EXCEPTION = emitter -> {
        emitter.emit(Locations.NONE, 89);
        emitter.emit(Locations.NONE, SystemEmitMethods.IS_CATCHABLE_EXCEPTION);
        emitter.unbox(TypeInfos.BOOLEAN);
        Label exit = new Label();
        emitter.emitJump(Locations.NONE, 154, exit);
        emitter.emit(Locations.NONE, 191);
        emitter.emit(exit);
    };
    private final Location loc;
    private final Statement tryBlock;
    private final List<CatchBlockStatement> catchBlocks;
    private final Statement finallyBlock;
    private final Emit finallyEmit;

    public TryCatchFinallyBlockStatement(AstNode definingNode, Stmnt.TryCatchFinallyBlock stmnt) {
        super(definingNode);
        this.loc = stmnt.loc;
        this.tryBlock = AstNodes.get().create((AstNode)this, stmnt.tryBlock);
        this.catchBlocks = AstNodes.filterNullTransform(stmnt.catchBlocks, catchBlock -> new CatchBlockStatement(this, (CatchBlock)catchBlock));
        this.finallyBlock = stmnt.finallyBlock.map(value -> AstNodes.get().create((AstNode)this, value.stmnt)).orElse(NOOP);
        this.finallyEmit = stmnt.finallyBlock.map(value -> this.finallyBlock::emit).orElse(Emit.NOOP);
        if (this.tryBlock.isReturnable() && MoreIterables.ensureAll(this.catchBlocks, Statement::isReturnable)) {
            this.setReturnable();
        }
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.tryBlock.traverse(visitor, scope);
            for (CatchBlockStatement catchBlock : this.catchBlocks) {
                catchBlock.traverse(visitor, scope);
            }
            this.finallyBlock.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        HashSet<TypeInfo> uniqueExceptions = new HashSet<TypeInfo>();
        this.tryBlock.validate(symbols, scope);
        Errors errors = scope.getErrors();
        for (CatchBlockStatement catchBlock : this.catchBlocks) {
            catchBlock.validate(symbols, scope);
            TypeInfo type = catchBlock.getVariable().getType();
            if (!type.isResolved()) continue;
            for (TypeInfo otherType : uniqueExceptions) {
                if (!ExceptionTypeInfoUtil.canExceptionBeCaught(type, catchBlock.getTypeRef()) || !Distance.get().canAssign(this.getDefiningType(), type, otherType)) continue;
                errors.markInvalid((AstNode)catchBlock, I18nSupport.getLabel("invalid.catch.duplicate.exception", type));
            }
            uniqueExceptions.add(type);
        }
        this.finallyBlock.validate(symbols, scope);
        if (errors.isInvalid(this.catchBlocks) || errors.isInvalid(this.tryBlock, this.finallyBlock)) {
            errors.markInvalid(this);
        }
        if (this.catchBlocks.isEmpty() && this.finallyBlock == Statement.NOOP) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.try.needs.catch.or.finally"));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        TryCatchFinallyStack.TryCatchFinallyContext context = emitter.getTryCatchFinallyStack().push(this.finallyEmit);
        emitter.getTryCatchFinallyStack().startTryBlock();
        emitter.emitStatementExecuted(this.loc, false, true);
        emitter.emit(context.getTryStartForCatch());
        this.tryBlock.emit(emitter);
        emitter.getTryCatchFinallyStack().endBlock();
        if (!this.catchBlocks.isEmpty()) {
            emitter.emitJump(Locations.NONE, 167, context.getExit());
        }
        for (CatchBlockStatement catchBlock : this.catchBlocks) {
            catchBlock.emit(emitter);
        }
        emitter.getTryCatchFinallyStack().pop(UNCATCHABLE_EXCEPTION);
        emitter.emit(context.getExit());
        emitter.emit(Locations.NONE, 0);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Statement getTryBlock() {
        return this.tryBlock;
    }

    public List<CatchBlockStatement> getCatchBlocks() {
        return this.catchBlocks;
    }

    public Statement getFinallyBlock() {
        return this.finallyBlock;
    }
}

