/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.ast.statement.Statement;

public class StatementExecuted
extends SimpleStatement {
    private final Location executedLoc;
    private final Location statementLoc;
    private final boolean zeroStatements;
    private final boolean trackCodeCoverage;

    private StatementExecuted(AstNode definingNode, Location executedLoc, Location statementLoc, boolean zeroStatements, boolean trackCodeCoverage) {
        super(definingNode, SimpleStatement.Returnable.NO);
        this.executedLoc = executedLoc;
        this.statementLoc = statementLoc;
        this.zeroStatements = zeroStatements;
        this.trackCodeCoverage = trackCodeCoverage;
    }

    public static Statement createSynthetic(AstNode definingNode, Location loc, boolean zeroStatements, boolean trackCodeCoverage) {
        return new StatementExecuted(definingNode, loc, Locations.NONE, zeroStatements, trackCodeCoverage);
    }

    public static Statement createReal(AstNode definingNode, Location loc, boolean zeroStatements, boolean trackCodeCoverage) {
        return new StatementExecuted(definingNode, loc, loc, zeroStatements, trackCodeCoverage);
    }

    @Override
    public Location getLoc() {
        return this.statementLoc;
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.executedLoc, this.zeroStatements, this.trackCodeCoverage);
    }
}

