/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Identifier;
import apex.jorje.data.JadtFactory;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.PolymorphicTypes;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.variable.ConstantValue;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.services.I18nSupport;
import java.util.Optional;

public class FieldDeclaration
extends Statement {
    private final FieldDeclarationStatements declarations;
    private final Identifier name;
    private final Expression store;
    private final Expression assignment;
    private final Object constant;
    private FieldInfo fieldInfo;

    FieldDeclaration(FieldDeclarationStatements declarations, VariableDecl variableDecl) {
        super(declarations);
        this.declarations = declarations;
        this.name = variableDecl.name;
        Expr.VariableExpr expr = JadtFactory.variableExpr(Optional.empty(), variableDecl.name);
        this.store = AstNodes.get().createStore(this, expr);
        this.assignment = variableDecl.assignment.map(value -> AstNodes.get().create((AstNode)this, (Expr)value)).orElse(Expression.NOOP);
        this.constant = ConstantValue.get(variableDecl.assignment);
    }

    public TypeRef getTypeNameUsed() {
        return this.declarations.getTypeName();
    }

    public TypeInfo getTypeInfoUsed() {
        return this.declarations.getType();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.assignment.traverse(visitor, scope);
            this.store.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        IdentifierContext context = scope.getMethod() != null && scope.getMethod().isStaticInitialization() ? IdentifierContext.STATIC : IdentifierContext.OBJECT;
        Variable variable = symbols.lookupVariableInfo(this.getDefiningType(), ReferenceType.LOAD, context, this.getDefiningType(), this.name);
        Errors errors = scope.getErrors();
        if (variable == null) {
            errors.markInvalid(this);
            return;
        }
        assert (variable instanceof FieldInfo);
        this.fieldInfo = (FieldInfo)variable;
        symbols.fields().setAssignment(this.fieldInfo);
        this.assignment.validate(symbols, scope);
        symbols.fields().clear();
        symbols.fields().setDeclaration(this.fieldInfo);
        this.store.validate(symbols, scope);
        symbols.fields().clear();
        errors.addIfError((AstNode)this, this.name.getLoc(), IdentifierValidator.get().validate(this.getDefiningType(), this.name.getValue(), IdentifierValidator.Type.VARIABLE, false, false));
        if (errors.isInvalid(this.assignment, this.store)) {
            errors.markInvalid(this);
            return;
        }
        if (this.assignment != Expression.NOOP && !PolymorphicTypes.isAssignable(this.getDefiningType(), this.assignment, this.fieldInfo.getType())) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("illegal.assignment", this.assignment.getType(), this.fieldInfo.getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        boolean isClinit = emitter.getMethodStack().peek().getMethodInfo().isStaticInitialization();
        if (this.assignment != Expression.NOOP) {
            if (isClinit && this.fieldInfo.getModifiers().has(ModifierTypeInfos.FINAL) && this.fieldInfo.getType().getBasicType() == BasicType.STRING && this.constant != null) {
                return;
            }
            emitter.emitStatementExecuted(this.fieldInfo.getLoc(), true, false);
            if (!this.declarations.getModifiers().has(ModifierTypeInfos.STATIC) && this.fieldInfo.getDefiningType().getUnitType() != UnitType.TRIGGER && this.fieldInfo.getDefiningType().getUnitType() != UnitType.ANONYMOUS) {
                emitter.emitVar(this.fieldInfo.getLoc(), 25, 0);
            }
            this.assignment.emit(emitter);
            TypeConversion.emitOrCheckCast(this.fieldInfo.getLoc(), emitter, this.assignment.getType(), this.fieldInfo.getType());
            this.store.emit(emitter);
        } else {
            if (isClinit) {
                return;
            }
            emitter.emitStatementExecuted(this.fieldInfo.getLoc(), true, false);
            UnitType unitType = this.getDefiningType().getUnitType();
            if (unitType == UnitType.ANONYMOUS || unitType == UnitType.TRIGGER) {
                emitter.emit(this.fieldInfo.getLoc(), 1);
                this.store.emit(emitter);
            }
        }
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    @SfdcCalled
    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public Expression getAssignment() {
        return this.assignment;
    }
}

