/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.services.I18nSupport;
import com.google.common.collect.Sets;
import java.util.Set;

public enum Element {
    FIELD("field.plural"),
    PROPERTY("property.plural"),
    LOCAL("local.plural"),
    PARAMETER("parameter.plural"),
    METHOD("method.plural"),
    CONSTRUCTOR("constructor.plural"),
    CLASS("class.plural"),
    INTERFACE("interface.plural"),
    ENUM("enum.plural"),
    TRIGGER("trigger.plural");

    private static final Set<Element> IS_TYPE;
    private final String name;

    private Element(String label) {
        this.name = I18nSupport.getLabel(label);
    }

    public String toString() {
        return this.name;
    }

    public boolean isType() {
        return IS_TYPE.contains((Object)this);
    }

    static {
        IS_TYPE = Sets.immutableEnumSet((Enum)CLASS, (Enum[])new Element[]{INTERFACE, ENUM, TRIGGER});
    }
}

