/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.common.base.ObjectHash;
import apex.jorje.data.Location;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Objects;

public class Modifier
extends ModifierOrAnnotation {
    private final Location loc;
    private final ModifierTypeInfo type;

    Modifier(Location loc, ModifierTypeInfo type) {
        this.loc = loc;
        this.type = type;
        this.setType(type);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
    }

    @Override
    public void emit(Emitter emitter) {
        if (this.type.isBytecodeVisible()) {
            emitter.getAnnotationVisitor().get().getAnnotationVisitor().visit(this.getType().getBytecodeName(), (Object)true);
            if (this.type == ModifierTypeInfos.TEST_METHOD) {
                emitter.getAnnotationVisitor().get().getAnnotationVisitor().visit("testMethod@isParallel", (Object)false);
                emitter.getAnnotationVisitor().get().getAnnotationVisitor().visit("testMethod@onInstall", (Object)false);
                emitter.getAnnotationVisitor().get().getAnnotationVisitor().visit("testMethod@seeAllData", (Object)false);
            }
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public ModifierTypeInfo getModifierType() {
        return this.type;
    }

    @Override
    public AnnotationParameter getParameter(String name) {
        return null;
    }

    public String toString() {
        return this.type.toString();
    }

    public int hashCode() {
        return ObjectHash.hash(this.type, this.loc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Modifier)) {
            return false;
        }
        Modifier modifier = (Modifier)o;
        return Objects.equals(this.loc, modifier.loc) && Objects.equals(this.type, modifier.type);
    }
}

