/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.bridge.Bridge;
import apex.jorje.semantic.ast.member.bridge.EqualsBridge;
import apex.jorje.semantic.ast.member.bridge.HashCodeBridge;
import apex.jorje.semantic.ast.member.bridge.InheritanceBridge;
import apex.jorje.semantic.ast.member.bridge.InterfaceBridge;
import apex.jorje.semantic.ast.member.bridge.InterfaceErasedBridge;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class BridgeMethodCreator
implements AstNode {
    private static final Set<Bridge> BRIDGES = ImmutableSet.of(HashCodeBridge.get(), EqualsBridge.get(), InheritanceBridge.get(), InterfaceBridge.get(), InterfaceErasedBridge.get());
    private final Set<Bridge> bridges;
    private final TypeInfo definingType;
    private List<Method> bridgeMethods;

    public BridgeMethodCreator(AstNode definingNode) {
        this(definingNode, BRIDGES);
    }

    BridgeMethodCreator(AstNode definingNode, Set<Bridge> bridges) {
        this.definingType = definingNode.getDefiningType();
        this.bridges = bridges;
    }

    public void createMethods(SymbolResolver symbols) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Stream.concat(this.definingType.virtualMethods().all().stream(), this.definingType.methods().getStatics().stream()).filter(method -> method.getGenerated().isUserDefined() && (this.definingType == method.getDefiningType() || method.getGenerated() != Generated.SYSTEM)).forEach(method -> {
            for (Bridge bridge : this.bridges) {
                for (Supplier<Method> supplier : bridge.create(this, (MethodInfo)method)) {
                    Method bridgeMethod = supplier.get();
                    bridgeMethod.resolve(symbols);
                    builder.add(bridgeMethod);
                }
            }
        });
        this.bridgeMethods = builder.build();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope) && this.bridgeMethods != null) {
            for (Method method : this.bridgeMethods) {
                method.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        for (Method method : this.bridgeMethods) {
            method.validate(symbols, scope);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        assert (this.bridgeMethods != null);
        for (Method method : this.bridgeMethods) {
            method.emit(emitter);
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    List<Method> getMethods() {
        return this.bridgeMethods;
    }
}

