/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Identifier;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.NestedExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import java.util.List;

final class ReferenceExpressionUtil {
    private static final VariableVisitor<Boolean, Void> IS_AGGREGATE_FIELD = new VariableVisitor.Default<Boolean, Void>(){

        @Override
        protected Boolean _default(Variable info, Void context) {
            return false;
        }

        @Override
        public Boolean visit(SObjectFieldInfo info, Void context) {
            return info.getCategory() == SObjectFieldInfo.Category.AGGREGATE;
        }
    };
    private static final AstVisitor<BooleanScope> IS_PEELABLE = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(VariableExpression node, BooleanScope scope) {
            if (SObjectTypeInfoUtil.isConcreteSObjectList(node.getType())) {
                scope.setValue((Boolean)node.getVariable().accept(IS_AGGREGATE_FIELD, VariableVisitor.Context.NONE));
            }
        }
    };

    private ReferenceExpressionUtil() {
    }

    static TypeInfo getStartType(TypeInfo definingType, boolean shouldPeelType, Expression dottedExpression) {
        if (dottedExpression == Expression.NOOP) {
            return definingType;
        }
        return shouldPeelType ? CollectionTypeInfoUtil.getElementType(dottedExpression.getType()) : dottedExpression.getType();
    }

    static PeelType shouldPeelType(ReferenceType reference, List<Identifier> names, Expression dottedExpression) {
        boolean hasFieldPaths;
        boolean bl = hasFieldPaths = reference != ReferenceType.METHOD || !names.isEmpty();
        if (hasFieldPaths) {
            if (ExpressionUtil.isSoqlExpression(dottedExpression)) {
                return PeelType.SOQL;
            }
            if (ReferenceExpressionUtil.isNestedAggregated(dottedExpression)) {
                return PeelType.NESTED_AGGREGATE;
            }
            if (CollectionTypeInfoUtil.isQueryResultList(dottedExpression.getType())) {
                return PeelType.QUERY_RESULT_WITHOUT_SOQL;
            }
        }
        return PeelType.NONE;
    }

    private static boolean isNestedAggregated(Expression dottedExpression) {
        return dottedExpression instanceof NestedExpression && BooleanScope.evaluate(((NestedExpression)dottedExpression).getExpression(), IS_PEELABLE, false);
    }

    public static enum PeelType {
        SOQL(true),
        QUERY_RESULT_WITHOUT_SOQL(true),
        NESTED_AGGREGATE(true),
        NONE(false);

        private final boolean isPeelable;

        private PeelType(boolean isPeelable) {
            this.isPeelable = isPeelable;
        }

        public boolean isPeelable() {
            return this.isPeelable;
        }
    }
}

