/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.StringConcatenation;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DecimalEmitMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;

public class LiteralExpression
extends Expression {
    private final Object literal;
    private final Location loc;
    private final LiteralType literalType;

    public LiteralExpression(AstNode definingNode, Expr.LiteralExpr expr) {
        super(definingNode);
        this.literal = expr.literal;
        this.literalType = expr.type;
        this.loc = expr.loc;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (this.literalType == null) {
            scope.getErrors().markInvalid(this);
            return;
        }
        switch (this.literalType) {
            case STRING: {
                this.setType(TypeInfos.STRING);
                break;
            }
            case INTEGER: {
                this.setType(TypeInfos.INTEGER);
                break;
            }
            case LONG: {
                this.setType(TypeInfos.LONG);
                break;
            }
            case DOUBLE: {
                this.setType(TypeInfos.DOUBLE);
                break;
            }
            case DECIMAL: {
                this.setType(TypeInfos.DECIMAL);
                break;
            }
            case TRUE: 
            case FALSE: {
                this.setType(TypeInfos.BOOLEAN);
                break;
            }
            case NULL: {
                this.setType(InternalTypeInfos.NULL);
            }
        }
    }

    @Override
    public void emit(Emitter emitter) {
        switch (this.literalType) {
            case STRING: {
                StringConcatenation.emitLiteral(this, emitter, (String)this.literal);
                break;
            }
            case INTEGER: {
                emitter.push(this.loc, (Integer)this.literal);
                emitter.box(this.getType());
                break;
            }
            case LONG: {
                emitter.push(this.loc, (Long)this.literal);
                emitter.box(this.getType());
                break;
            }
            case DOUBLE: {
                emitter.push(this.loc, (Double)this.literal);
                emitter.box(this.getType());
                break;
            }
            case DECIMAL: {
                emitter.push(this.loc, this.literal.toString());
                emitter.emit(this.loc, DecimalEmitMethods.VALUE_OF_BYTECODE);
                break;
            }
            case TRUE: {
                emitter.push(this.loc, true);
                emitter.box(this.getType());
                break;
            }
            case FALSE: {
                emitter.push(this.loc, false);
                emitter.box(this.getType());
                break;
            }
            case NULL: {
                emitter.emit(this.loc, 1);
            }
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Object getLiteral() {
        return this.literal;
    }

    public LiteralType getLiteralType() {
        return this.literalType;
    }
}

