/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.ArgumentTypeCalculator;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.CompilationUtil;
import apex.jorje.semantic.ast.compilation.ConstructorPreamble;
import apex.jorje.semantic.ast.compilation.EmitOrder;
import apex.jorje.semantic.ast.compilation.ScriptTooLargeValidator;
import apex.jorje.semantic.ast.compilation.UserClassMembers;
import apex.jorje.semantic.ast.compilation.UserClassMethods;
import apex.jorje.semantic.ast.compilation.UserExceptionMethods;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.ValidationSettings;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.objectweb.asm.ClassVisitor;

public class UserClass
extends Compilation {
    private final TypeInfo classType;
    private final UserClassMembers members;
    private final AstNode additionalMethods;
    private final AstNode bridgeMethods;
    private final AstNode preamble;
    private final AdditionalInfo additionalInfo;
    private final ModifierNode modifiers;
    private final Identifier name;
    private final Location bodyLoc;

    public UserClass(Errors errors, SourceFile source, AstNode definingNode, CompilationUnit.ClassDeclUnit compilationUnit) {
        ClassDecl body = compilationUnit.body;
        this.name = compilationUnit.body.name;
        List<TypeInfo> argumentTypeInfos = ArgumentTypeCalculator.get().toArgumentTypes(errors, this, compilationUnit.body.typeArguments);
        StandardTypeInfoImpl.Builder builder = argumentTypeInfos.isEmpty() ? StandardTypeInfoImpl.builder() : GenericTypeInfo.builder().setTypeArguments(argumentTypeInfos);
        this.classType = ((AbstractTypeInfo.Builder)builder.setViaSource(source, AstNodes.getDefiningType(definingNode), compilationUnit)).build();
        this.members = UserClassMembers.create(this, errors, source, definingNode, this.classType, compilationUnit.body);
        this.preamble = new ConstructorPreamble(this, this.members.getStatements());
        this.additionalMethods = TypeNameUtil.isException(this.classType.getApexName()) ? new UserExceptionMethods(this, body.loc) : new UserClassMethods(this, this.name.getLoc());
        this.bridgeMethods = new BridgeMethodCreator(this);
        this.additionalInfo = AdditionalInfo.builder().setDefiningNode(this).setInnerTypes(this.members.getInnerTypes()).setProperties(this.members.getProperties()).build();
        this.modifiers = new ModifierNode(this, this.classType.getModifiers());
        this.bodyLoc = compilationUnit.body.loc;
    }

    public List<Statement> getStatements() {
        return this.members.getStatements();
    }

    public ModifierNode getModifiers() {
        return this.modifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.modifiers.traverse(visitor, scope);
                for (Compilation innerType : this.members.getInnerTypes()) {
                    innerType.traverse(visitor, scope);
                }
                for (AstNode field : this.members.getFieldsAndProperties()) {
                    field.traverse(visitor, scope);
                }
                this.preamble.traverse(visitor, scope);
                for (Method method : this.members.getMethods()) {
                    method.traverse(visitor, scope);
                }
                this.additionalMethods.traverse(visitor, scope);
                this.bridgeMethods.traverse(visitor, scope);
                this.additionalInfo.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            Errors errors = scope.getErrors();
            errors.addIfError(this, CompilationUtil.validateHasTopLevelModifiers(this));
            errors.addIfError((AstNode)this, this.name.getLoc(), IdentifierValidator.get().validate(this.classType, this.name.getValue(), IdentifierValidator.Type.CLASS, TypeInfoUtil.isTopLevel(this.classType), false));
            if (errors.isInvalid(this) && scope.getBehavior() == ValidationSettings.ValidationBehavior.BREAK_ON_FIRST_ERROR) {
                return;
            }
            if (ScriptTooLargeValidator.isScriptTooLarge(this.classType, symbols.getAccessEvaluator())) {
                scope.getErrors().markInvalid((AstNode)this, ScriptTooLargeValidator.createScriptTooLargeError(this.classType.getCodeUnitDetails().getSource()));
                return;
            }
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.validate(symbols, scope);
            }
            for (AstNode field : this.members.getFieldsAndProperties()) {
                field.validate(symbols, scope);
            }
            this.preamble.validate(symbols, scope);
            for (Method method : this.members.getMethods()) {
                method.validate(symbols, scope);
            }
            this.additionalMethods.validate(symbols, scope);
            this.bridgeMethods.validate(symbols, scope);
            this.additionalInfo.validate(symbols, scope);
            this.modifiers.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        CompilationOutput.Builder output = CompilationOutput.builder(this.classType);
        TypeStack.TypeContext clazz = TypeStack.TypeContext.builder().setType(this.classType).build();
        emitter.getTypeStack().push(clazz);
        try {
            emitter.getAnnotationVisitor().set((ClassVisitor)clazz.getClassWriter());
            this.modifiers.emit(emitter);
            emitter.getAnnotationVisitor().unset();
            this.additionalInfo.emitAnnotation(emitter);
            this.additionalMethods.emit(emitter);
            this.members.getMethods().stream().sorted(EmitOrder.get()).forEach(method -> method.emit(emitter));
            for (AstNode field : this.members.getFieldsAndProperties()) {
                field.emit(emitter);
            }
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.emit(emitter);
                output.addInnerType(innerType);
            }
            this.bridgeMethods.emit(emitter);
            this.additionalInfo.emit(emitter);
        }
        finally {
            byte[] bytes = CompilationUtil.getBytesOrAddTooLargeError(clazz.getClassWriter(), this, emitter.getCodeUnit().getErrors());
            emitter.getTypeStack().pop();
            this.setOutput(output.setBytes(bytes).setLines(clazz.getKnownCodeLocations()).build());
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.classType;
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    public Location getBodyLoc() {
        return this.bodyLoc;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("classType", this.classType).add("members", this.members).toString();
    }
}

