/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.AnonymousClassMembers;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.ScriptTooLargeValidator;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.base.MoreObjects;

public class AnonymousClass
extends Compilation {
    private final TypeInfo classType;
    private final Location loc;
    private final AnonymousClassMembers members;
    private final AdditionalInfo additionalInfo;

    public AnonymousClass(Errors errors, SourceFile source, CompilationUnit.AnonymousBlockUnit anonymousBlock) {
        this.loc = Locations.from(anonymousBlock);
        this.classType = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setViaSource(source, anonymousBlock)).build();
        this.members = AnonymousClassMembers.create(this, errors, source, this.classType, anonymousBlock);
        this.additionalInfo = AdditionalInfo.builder().setDefiningNode(this).setProperties(this.members.getProperties()).build();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        if (visitor.visit(this, scope)) {
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.traverse(visitor, scope);
            }
            for (Field field : this.members.getFields()) {
                field.traverse(visitor, scope);
            }
            for (Property property : this.members.getProperties()) {
                property.traverse(visitor, scope);
            }
            for (Method method : this.members.getMethods()) {
                method.traverse(visitor, scope);
            }
            this.additionalInfo.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
        scope.pop(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            if (scope.getErrors().isInvalid(this)) {
                return;
            }
            if (ScriptTooLargeValidator.isScriptTooLarge(this.classType, symbols.getAccessEvaluator())) {
                scope.getErrors().markInvalid((AstNode)this, ScriptTooLargeValidator.createScriptTooLargeError(this.classType.getCodeUnitDetails().getSource()));
                return;
            }
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.validate(symbols, scope);
            }
            for (Field field : this.members.getFields()) {
                field.validate(symbols, scope);
            }
            for (Property property : this.members.getProperties()) {
                property.validate(symbols, scope);
            }
            for (Method method : this.members.getMethods()) {
                method.validate(symbols, scope);
            }
            this.additionalInfo.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        CompilationOutput.Builder output = CompilationOutput.builder(this.classType);
        TypeStack.TypeContext clazz = TypeStack.TypeContext.builder().setType(this.classType).build();
        emitter.getTypeStack().push(clazz);
        try {
            this.additionalInfo.emitAnnotation(emitter);
            for (Method method : this.members.getMethods()) {
                method.emit(emitter);
            }
            for (Field field : this.members.getFields()) {
                field.emit(emitter);
            }
            for (Property property : this.members.getProperties()) {
                property.emit(emitter);
            }
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.emit(emitter);
                output.addInnerType(innerType);
            }
            emitter.getProxyMethodTable().emit();
            this.additionalInfo.emit(emitter);
        }
        finally {
            emitter.getTypeStack().pop();
            this.setOutput(output.setBytes(clazz.getClassWriter().toByteArray()).setLines(clazz.getKnownCodeLocations()).build());
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.classType;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("classType", this.classType).add("members", this.members).toString();
    }
}

