/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.lsp.impl.utils.ParentTableUtil;
import apex.jorje.lsp.impl.utils.ParentTableVisitor;
import apex.jorje.lsp.impl.utils.TypeUsageSiteProcessor;
import apex.jorje.lsp.impl.utils.TypeUsageSiteUtil;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.TypeWhenBlock;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.statement.WhenCases;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class ReferenceSourceVisitor
extends AstVisitor<AdditionalPassScope> {
    public static final VariableVisitor<Boolean, Void> IS_LOCAL = new VariableVisitor.Default<Boolean, Void>(){

        @Override
        public Boolean _default(Variable info, Void context) {
            return false;
        }

        @Override
        public Boolean visit(LocalInfo info, Void context) {
            return true;
        }
    };
    private final int selectionOffset;
    private Optional<Either<TypeInfo, Member>> symbol = Optional.empty();

    public ReferenceSourceVisitor(int selectionOffset) {
        this.selectionOffset = selectionOffset;
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(VariableExpression node, AdditionalPassScope scope) {
        Variable variable;
        super.visitEnd(node, scope);
        int startIndex = node.getLoc().getStartIndex();
        int endIndex = node.getLoc().getEndIndex();
        if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (variable = node.getVariable()) != null) {
            this.setReferenceSource(variable);
        }
    }

    @Override
    public void visitEnd(Property property, AdditionalPassScope scope) {
        super.visitEnd(property, scope);
        Location location = property.getLoc();
        if (this.selectionOffset >= location.getStartIndex() && location.getEndIndex() >= this.selectionOffset) {
            this.setReferenceSource(property.getFieldInfo());
        }
    }

    @Override
    public void visitEnd(FieldDeclaration field, AdditionalPassScope scope) {
        super.visitEnd(field, scope);
        TypeUsageSiteUtil.processTypeUsageSite(field.getTypeNameUsed(), field.getTypeInfoUsed(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
    }

    @Override
    public void visitEnd(VariableDeclaration variable, AdditionalPassScope scope) {
        super.visitEnd(variable, scope);
        TypeUsageSiteUtil.processTypeUsageSite(variable.getTypeNameUsed(), variable.getTypeInfoUsed(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
    }

    @Override
    public void visitEnd(ReferenceExpression node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        List<Identifier> names = node.getNames();
        List<Variable> variables = node.getVariables();
        List<Identifier> nonVariableNames = names.subList(0, names.size() - variables.size());
        List<Identifier> variableNames = names.subList(nonVariableNames.size(), names.size());
        if (!nonVariableNames.isEmpty()) {
            TypeUsageSiteUtil.processTypeUsageSite(nonVariableNames, node.getType(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
        }
        block0: for (Identifier name : variableNames) {
            int startIndex = name.getLoc().getStartIndex();
            int endIndex = name.getLoc().getEndIndex();
            if (this.selectionOffset < startIndex || endIndex < this.selectionOffset) continue;
            for (Variable variable : variables) {
                if (name.getValue().equalsIgnoreCase(variable.getName()) && (variable.getMemberType() == Member.Type.FIELD || variable.getMemberType() == Member.Type.PROPERTY)) {
                    this.setReferenceSource(variable);
                    continue block0;
                }
                variable.accept(new VariableVisitor.Default<Void, Void>(){

                    @Override
                    public Void _default(Variable info, Void context) {
                        return null;
                    }

                    @Override
                    public Void visit(LocalInfo info, Void context) {
                        ReferenceSourceVisitor.this.setReferenceSource(info);
                        return null;
                    }
                }, VariableVisitor.Context.NONE);
            }
        }
    }

    @Override
    public void visitEnd(Method node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        int startIndex = node.getLoc().getStartIndex();
        int endIndex = node.getLoc().getEndIndex();
        if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset) {
            this.setReferenceSource(node.getMethodInfo());
            return;
        }
        MethodInfo methodInfo = node.getMethodInfo();
        for (Parameter param : methodInfo.getParameters()) {
            Location paramLocation = param.getLoc();
            if (this.selectionOffset >= paramLocation.getStartIndex() && paramLocation.getEndIndex() >= this.selectionOffset) {
                this.setReferenceSource(param.getVariable());
                continue;
            }
            TypeUsageSiteUtil.processTypeUsageSite(param.getTypeRef(), param.getType(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
        }
        TypeRef returnTypeRef = node.getReturnTypeRef();
        if (!returnTypeRef.getNames().isEmpty()) {
            TypeUsageSiteUtil.processTypeUsageSite(returnTypeRef, methodInfo.getReturnType(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
        }
    }

    @Override
    public void visitEnd(MethodCallExpression node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        int startIndex = node.getLoc().getStartIndex();
        int endIndex = node.getLoc().getEndIndex();
        if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && node.getMethod().isPresent()) {
            this.setReferenceSource(node.getMethod().get());
        }
    }

    @Override
    public void visitEnd(NewObjectExpression node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        List<Identifier> newObjectNames = node.getTypeRef().getNames();
        Location location = Iterables.getLast(newObjectNames).getLoc();
        if (this.selectionOffset >= location.getStartIndex() && location.getEndIndex() >= this.selectionOffset && node.getConstructor().isPresent()) {
            this.setReferenceSource(node.getConstructor().get());
        }
    }

    @Override
    public void visitEnd(SuperMethodCallExpression node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        int startIndex = node.getLoc().getStartIndex();
        int endIndex = node.getLoc().getEndIndex();
        if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && node.getMethod().isPresent()) {
            this.setReferenceSource(node.getMethod().get());
        }
    }

    @Override
    public void visitEnd(ThisMethodCallExpression node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        int startIndex = node.getLoc().getStartIndex();
        int endIndex = node.getLoc().getEndIndex();
        if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && node.getMethod().isPresent()) {
            this.setReferenceSource(node.getMethod().get());
        }
    }

    @Override
    public void visitEnd(CatchBlockStatement catchStatement, AdditionalPassScope scope) {
        super.visitEnd(catchStatement, scope);
        TypeUsageSiteUtil.processTypeUsageSite(catchStatement.getTypeRef(), catchStatement.getVariable().getType(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
        Location excNameLocation = catchStatement.getVariable().getLoc();
        if (this.selectionOffset >= excNameLocation.getStartIndex() && excNameLocation.getEndIndex() >= this.selectionOffset) {
            this.setReferenceSource(catchStatement.getVariable());
        }
    }

    @Override
    public void visitEnd(CastExpression castExpression, AdditionalPassScope scope) {
        super.visitEnd(castExpression, scope);
        if (castExpression.getCastType() != null) {
            TypeUsageSiteUtil.processTypeUsageSite(castExpression.getTypeRef(), castExpression.getCastType(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
        }
    }

    @Override
    public void visitEnd(NewListInitExpression listInit, AdditionalPassScope scope) {
        super.visitEnd(listInit, scope);
        TypeUsageSiteUtil.processTypeUsageSite(listInit.getTypeRef(), listInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
    }

    @Override
    public void visitEnd(NewSetInitExpression setInit, AdditionalPassScope scope) {
        super.visitEnd(setInit, scope);
        TypeUsageSiteUtil.processTypeUsageSite(setInit.getTypeRef(), setInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
    }

    @Override
    public void visitEnd(NewMapInitExpression mapInit, AdditionalPassScope scope) {
        super.visitEnd(mapInit, scope);
        TypeUsageSiteUtil.processTypeUsageSite(mapInit.getTypeRef(), mapInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
    }

    @Override
    public void visitEnd(NewListLiteralExpression listInit, AdditionalPassScope scope) {
        super.visitEnd(listInit, scope);
        TypeUsageSiteUtil.processTypeUsageSite(listInit.getTypeRef(), listInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
    }

    @Override
    public void visitEnd(NewSetLiteralExpression setInit, AdditionalPassScope scope) {
        super.visitEnd(setInit, scope);
        TypeUsageSiteUtil.processTypeUsageSite(setInit.getTypeRef(), setInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
    }

    @Override
    public void visitEnd(NewMapLiteralExpression mapInit, AdditionalPassScope scope) {
        super.visitEnd(mapInit, scope);
        TypeUsageSiteUtil.processTypeUsageSite(mapInit.getTypeRef(), mapInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
    }

    @Override
    public void visitEnd(InstanceOfExpression instanceExpression, AdditionalPassScope scope) {
        super.visitEnd(instanceExpression, scope);
        TypeUsageSiteUtil.processTypeUsageSite(instanceExpression.getTypeRef(), instanceExpression.getInstanceOfType(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
    }

    @Override
    public void visitEnd(TypeWhenBlock node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        TypeUsageSiteUtil.processTypeUsageSite(node.getTypeRef(), node.getType(), (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
        LocalInfo whenVariable = node.getVariable();
        if (this.selectionOffset >= whenVariable.getLoc().getStartIndex() && whenVariable.getLoc().getEndIndex() >= this.selectionOffset) {
            this.setReferenceSource(whenVariable);
        }
    }

    @Override
    public void visitEnd(WhenCases.IdentifierCase node, AdditionalPassScope scope) {
        FieldInfo fieldInfo;
        int startIndex = node.getLoc().getStartIndex();
        int endIndex = node.getLoc().getEndIndex();
        if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (fieldInfo = node.getFieldInfo()) != null) {
            this.setReferenceSource(fieldInfo);
        }
    }

    @Override
    public void visitEnd(UserClass node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        ParentTableUtil.walkUserClassParentTable(node, new FindParentTableRefSource(this.selectionOffset));
    }

    @Override
    public void visitEnd(UserInterface node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        ParentTableUtil.walkInterfaceParentTable(node, new FindParentTableRefSource(this.selectionOffset));
    }

    @Override
    public void visitEnd(UserEnum node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        if (this.selectionOffset >= node.getLoc().getStartIndex() && node.getLoc().getEndIndex() >= this.selectionOffset) {
            this.setReferenceSource(node.getDefiningType());
        }
        for (FieldInfo enumField : node.getDefiningType().fields().all()) {
            if (this.selectionOffset < enumField.getLoc().getStartIndex() || enumField.getLoc().getEndIndex() < this.selectionOffset) continue;
            this.setReferenceSource(enumField);
        }
    }

    @Override
    public void visitEnd(UserTrigger node, AdditionalPassScope scope) {
        List<Identifier> names;
        Location location;
        super.visitEnd(node, scope);
        if (this.selectionOffset >= node.getLoc().getStartIndex() && node.getLoc().getEndIndex() >= this.selectionOffset) {
            this.setReferenceSource(node.getDefiningType());
        }
        if (this.selectionOffset >= (location = Iterables.getLast(names = node.getTargetName()).getLoc()).getStartIndex() && location.getEndIndex() >= this.selectionOffset) {
            this.setReferenceSource(node.getTargetType());
        }
    }

    @Override
    public boolean visit(UserClass node, AdditionalPassScope scope) {
        return true;
    }

    public Optional<Either<TypeInfo, Member>> getSymbol() {
        return this.symbol;
    }

    public void setReferenceSource(MethodInfo methodInfo) {
        this.symbol = Optional.of(Either.forRight((Object)methodInfo));
    }

    public void setReferenceSource(TypeInfo typeInfo) {
        this.symbol = Optional.of(Either.forLeft((Object)typeInfo));
    }

    public void setReferenceSource(Variable variable) {
        this.symbol = Optional.of(Either.forRight((Object)variable));
    }

    private class SetReferenceTypeUsage
    implements TypeUsageSiteProcessor {
        private final int selectOffset;

        public SetReferenceTypeUsage(int selectOffset) {
            this.selectOffset = selectOffset;
        }

        @Override
        public void processSite(String refName, TypeInfo refType, Location location) {
            if (this.selectOffset >= location.getStartIndex() && location.getEndIndex() >= this.selectOffset) {
                ReferenceSourceVisitor.this.setReferenceSource(refType);
            }
        }
    }

    private class FindParentTableRefSource
    implements ParentTableVisitor {
        private final int selectionOffset;

        public FindParentTableRefSource(int selectionOffset) {
            this.selectionOffset = selectionOffset;
        }

        @Override
        public boolean visit(Compilation node) {
            if (this.selectionOffset >= node.getLoc().getStartIndex() && node.getLoc().getEndIndex() >= this.selectionOffset) {
                ReferenceSourceVisitor.this.setReferenceSource(node.getDefiningType());
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(TypeRef typeRef, TypeInfo typeInfo) {
            TypeUsageSiteUtil.processTypeUsageSite(typeRef, typeInfo, (TypeUsageSiteProcessor)new SetReferenceTypeUsage(this.selectionOffset));
            return true;
        }
    }
}

