/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.typings;

import apex.jorje.lsp.impl.typings.TypeDefinitionModule;
import apex.jorje.lsp.impl.workspace.ServerSetup;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinitionWriter {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionWriter.class);
    private final Provider<ServerSetup> rootPathProvider;

    @Inject
    public TypeDefinitionWriter(Provider<ServerSetup> rootPathProvider) {
        this.rootPathProvider = rootPathProvider;
    }

    void writeModule(TypeDefinitionModule module) {
        Path typingsFolder;
        Path path = typingsFolder = module.kind == TypeDefinitionModule.Kind.APEX ? this.getApexTypingsFolder() : this.getSObjectTypingsFolder();
        if (!Files.exists(typingsFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(typingsFolder, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                logger.error("Failed to create typings folder", (Throwable)ioe);
            }
        }
        Path filePath = typingsFolder.resolve(module.fileName);
        try (BufferedWriter writer = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.append(module.moduleContents);
            writer.flush();
        }
        catch (IOException ioe) {
            logger.error("Failed to write contents of {}", (Object)module.fileName, (Object)ioe);
        }
    }

    Path getApexTypingsFolder() {
        String rootPath = ((ServerSetup)this.rootPathProvider.get()).getRootPath();
        return Paths.get(rootPath, ".sfdx", "typings", "lwc", "apex");
    }

    private Path getSObjectTypingsFolder() {
        String rootPath = ((ServerSetup)this.rootPathProvider.get()).getRootPath();
        return Paths.get(rootPath, ".sfdx", "typings", "lwc", "sobjects");
    }
}

