/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.rename;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.workspace.DependentCompilationTracker;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.index.symbol.VirtualStandardTypeInfo;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.utils.TypeInfoCache;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureEquivalence;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.TextEdit;

public class RenameUtil {
    public static String METADATA_SUFFIX = "-meta.xml";

    static List<TextEdit> fieldNameRewrites(AstNode node, final String newName) {
        final ImmutableList.Builder textEdits = ImmutableList.builder();
        node.traverse(new AstVisitor<NoopScope>(){

            @Override
            public boolean defaultVisit() {
                return true;
            }

            @Override
            public void visitEnd(VariableExpression expression, NoopScope scope) {
                super.visitEnd(expression, scope);
                Variable variable = expression.getVariable();
                if (variable != null && variable.getName().equalsIgnoreCase(newName) && expression.getContext().previous == IdentifierContext.NONE) {
                    textEdits.add(new TextEdit(Locations.Ranges.from(expression.getLoc()), RenameUtil.getFullyQualifiedName(variable)));
                }
            }
        }, NoopScope.get());
        return textEdits.build();
    }

    static List<TextEdit> methodNameRewrites(AstNode node, final Signature newSignature) {
        final ImmutableList.Builder textEdits = ImmutableList.builder();
        node.traverse(new AstVisitor<NoopScope>(){

            @Override
            public boolean defaultVisit() {
                return true;
            }

            @Override
            public void visitEnd(MethodCallExpression expression, NoopScope scope) {
                super.visitEnd(expression, scope);
                Optional<MethodInfo> method = expression.getMethod();
                if (method.isPresent() && SignatureEquivalence.isEquivalent(newSignature, method.get().getSignature()) && expression.getReferenceContext().getContext() == IdentifierContext.NONE) {
                    textEdits.add(new TextEdit(Locations.Ranges.from(expression.getLoc()), RenameUtil.getFullyQualifiedName(method.get())));
                }
            }
        }, NoopScope.get());
        return textEdits.build();
    }

    static boolean isFullyQualifiedReference(AstNode node, final int offset) {
        return BooleanScope.evaluate(node, new AstVisitor<BooleanScope>(){

            @Override
            public boolean defaultVisit() {
                return true;
            }

            @Override
            public void visitEnd(VariableExpression expression, BooleanScope scope) {
                super.visitEnd(expression, scope);
                if (expression.getLoc().getStartIndex() <= offset && expression.getLoc().getEndIndex() >= offset && expression.getContext().previous == IdentifierContext.NONE) {
                    scope.setValue(false);
                }
            }

            @Override
            public void visitEnd(MethodCallExpression expression, BooleanScope scope) {
                super.visitEnd(expression, scope);
                if (expression.getLoc().getStartIndex() <= offset && expression.getLoc().getEndIndex() >= offset && expression.getReferenceContext().getContext() == IdentifierContext.NONE) {
                    scope.setValue(false);
                }
            }
        }, true);
    }

    private static String getFullyQualifiedName(Member member) {
        return RenameUtil.getFullyQualifiedName(member, member.getName());
    }

    static String getFullyQualifiedName(Member member, String newName) {
        return member.getModifiers().has(ModifierTypeInfos.STATIC) ? member.getDefiningType().getApexName() + "." + newName : "this." + newName;
    }

    static TypeInfo getTypeInfo(Provider<ApexIndex> apexIndexProvider, SymbolResolver symbols, ApexTypeId apexId) {
        TypeInfo cachedInfo = TypeInfoCache.getTypeInfo(apexId.getApexName().toString());
        return cachedInfo != null ? cachedInfo : new VirtualStandardTypeInfo.Builder(symbols, apexIndexProvider).setApexTypeId(apexId).buildResolved();
    }

    static Map<String, CodeUnit> getUriToCodeUnitMap(List<Document> sourceDocuments, List<CodeUnit> codeUnits) {
        HashMap<String, CodeUnit> uriToCodeUnit = new HashMap<String, CodeUnit>();
        for (int i = 0; i < sourceDocuments.size(); ++i) {
            uriToCodeUnit.put(sourceDocuments.get(i).getUri().toString(), codeUnits.get(i));
        }
        return uriToCodeUnit;
    }

    static void addDependentCompilation(DependentCompilationTracker dependentCompilationTracker, String definitionUri, Set<String> referencesUri) {
        referencesUri.remove(definitionUri);
        if (!referencesUri.isEmpty()) {
            dependentCompilationTracker.addForIndexing(definitionUri, referencesUri.stream().collect(Collectors.toList()));
        }
    }

    static String renameFileUri(String oldUri, String newName) {
        String oldFileName = Paths.get(URI.create(oldUri)).getFileName().toString();
        String newFileName = oldFileName.replace(oldFileName.substring(0, oldFileName.indexOf(".")), newName);
        return oldUri.replace(oldFileName, newFileName);
    }
}

