/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.symbol;

import apex.common.base.MoreStrings;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Modifiers {
    private static final Logger logger = LoggerFactory.getLogger(Modifiers.class);
    private static final Map<String, ModifierTypeInfo> MODIFIERS_BY_NAME = Modifiers.mapModifiersByName();

    private static Map<String, ModifierTypeInfo> mapModifiersByName() {
        HashMap<String, ModifierTypeInfo> modifiers = Maps.newHashMap();
        for (Field field : ModifierTypeInfos.class.getDeclaredFields()) {
            if (!ModifierTypeInfo.class.isAssignableFrom(field.getType())) continue;
            try {
                ModifierTypeInfo type = (ModifierTypeInfo)ModifierTypeInfo.class.cast(field.get(null));
                modifiers.put(type.getBytecodeMethodName().toLowerCase(), type);
            }
            catch (Exception e) {
                logger.error("Failed to initialize modifiers by name", (Throwable)e);
            }
        }
        return modifiers;
    }

    static ModifierGroup toModifierGroup(String modifiersSeparatedBySpaces) {
        assert (MoreStrings.isLowerCase(modifiersSeparatedBySpaces));
        ArrayList<ModifierTypeInfo> typeInfos = Lists.newArrayList();
        for (String modifier : modifiersSeparatedBySpaces.split(" ")) {
            Optional.ofNullable(MODIFIERS_BY_NAME.get(modifier)).ifPresent(typeInfos::add);
        }
        return ModifierGroup.builder().addModifierTypes(typeInfos).build();
    }
}

