/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.node;

import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexClassInterfaceJunction;
import apex.jorje.lsp.impl.index.node.ApexReference;
import apex.jorje.lsp.impl.index.node.ApexTreeNode;
import apex.jorje.lsp.impl.index.node.ApexType;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.eclipse.jdt.internal.core.nd.field.FieldLong;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.eclipse.jdt.internal.core.nd.field.FieldSearchKey;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public class ApexResourceFile
extends ApexTreeNode {
    public static final StructDef<ApexResourceFile> type = StructDef.create(ApexResourceFile.class, ApexTreeNode.type);
    public static final FieldLong TIME_LAST_SCANNED;
    public static final FieldSearchKey<ApexIndex> FILENAME;
    static final FieldOneToMany<ApexType> TYPES;
    static final FieldOneToMany<ApexReference> REFERENCES;
    static final FieldOneToMany<ApexClassInterfaceJunction> JUNCTIONS;
    private static final FieldInt ERRORS;
    private static final FieldInt FILE_TYPE;
    private static final int NUM_TYPES_TO_INLINE = 16;
    private static final int NUM_REFERENCES_TO_INLINE = 16;
    private static final int NUM_JUNCTIONS_TO_INLINE = 16;

    public ApexResourceFile(Nd nd, long address) {
        super(nd, address);
    }

    public ApexResourceFile(Nd nd) {
        super(nd, null);
    }

    public List<ApexType> getTypes() {
        return TYPES.asList(this.getNd(), this.address);
    }

    public IString getFilename() {
        return FILENAME.get(this.getNd(), this.address);
    }

    public void setFilename(String filename) {
        FILENAME.put(this.getNd(), this.address, filename);
    }

    public long getTimeLastScanned() {
        return TIME_LAST_SCANNED.get(this.getNd(), this.address);
    }

    public void setTimeLastScanned(long timeLastUsed) {
        TIME_LAST_SCANNED.put(this.getNd(), this.address, timeLastUsed);
    }

    public void setError(boolean hasError) {
        ERRORS.put(this.getNd(), this.address, hasError ? 1 : 0);
    }

    public boolean isFileBased() {
        return FILE_TYPE.get(this.getNd(), this.address) != 0;
    }

    public void setFileBased(boolean isFileBased) {
        FILE_TYPE.put(this.getNd(), this.address, isFileBased ? 1 : 0);
    }

    public boolean hasError() {
        return ERRORS.get(this.getNd(), this.address) == 1;
    }

    static {
        TYPES = FieldOneToMany.create(type, ApexType.FILE, (int)16);
        REFERENCES = FieldOneToMany.create(type, ApexReference.FILE, (int)16);
        JUNCTIONS = FieldOneToMany.create(type, ApexClassInterfaceJunction.FILE, (int)16);
        TIME_LAST_SCANNED = type.addLong();
        FILENAME = FieldSearchKey.create(type, ApexIndex.FILES);
        FILE_TYPE = type.addInt();
        ERRORS = type.addInt();
        type.done();
    }
}

