/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.common.base.ObjectHash;
import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.ParameterRef;
import apex.jorje.data.ast.PrinterBlocks;
import apex.jorje.data.ast.TypeRef;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ParameterRefs {
    private static final EmptyModifierParameterRef INVALID_REF = new EmptyModifierParameterRef(null, null);

    private ParameterRefs() {
    }

    public static ParameterRef newParameterRef(List<Modifier> modifiers, TypeRef typeRef, Identifier name) {
        if (typeRef == null || name == null || name.getValue() == null) {
            return INVALID_REF;
        }
        return modifiers.isEmpty() ? new EmptyModifierParameterRef(typeRef, name) : new ModifierParameterRef(modifiers, typeRef, name);
    }

    public static ParameterRef newParameterRef(List<Modifier> modifiers, TypeRef typeRef, String name) {
        Identifier identifier = Identifiers.newIdentifier(name);
        return ParameterRefs.newParameterRef(modifiers, typeRef, identifier);
    }

    public static ParameterRef newParameterRef(TypeRef typeRef, Identifier name) {
        if (typeRef == null || name == null || name.getValue() == null) {
            return INVALID_REF;
        }
        return new EmptyModifierParameterRef(typeRef, name);
    }

    public static ParameterRef newParameterRef(TypeRef typeRef, String name) {
        Identifier identifier = Identifiers.newIdentifier(name);
        return ParameterRefs.newParameterRef(typeRef, identifier);
    }

    public static ParameterRef getInvalidParameterRef() {
        return INVALID_REF;
    }

    public static boolean isInvalidParameterRef(ParameterRef parameter) {
        return INVALID_REF == parameter;
    }

    public static boolean isValidParameterRef(ParameterRef parameter) {
        return INVALID_REF != parameter;
    }

    private static boolean equals(ParameterRef left, ParameterRef right) {
        return Objects.equals(left.getModifiers(), right.getModifiers()) && Objects.equals(left.getType(), right.getType()) && Objects.equals(left.getName(), right.getName());
    }

    private static int hash(ParameterRef parameter) {
        return ObjectHash.hash(parameter.getModifiers(), parameter.getType(), parameter.getName());
    }

    private static String toString(ParameterRef parameter) {
        if (parameter.getType() == null) {
            return "invalid parameter!!!";
        }
        if (parameter.getModifiers().isEmpty()) {
            return parameter.getType() + " " + parameter.getName().getValue();
        }
        String modifiers = parameter.getModifiers().stream().map(modifier -> PrinterBlocks.get().print((Modifier)modifier)).collect(Collectors.joining(" "));
        return modifiers + " " + parameter.getType() + " " + parameter.getName().getValue();
    }

    private static class ModifierParameterRef
    implements ParameterRef {
        private final List<Modifier> modifiers;
        private final TypeRef typeRef;
        private final Identifier name;

        private ModifierParameterRef(List<Modifier> modifiers, TypeRef typeRef, Identifier name) {
            this.modifiers = modifiers;
            this.typeRef = typeRef;
            this.name = name;
        }

        @Override
        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public TypeRef getType() {
            return this.typeRef;
        }

        @Override
        public Identifier getName() {
            return this.name;
        }

        public String toString() {
            return ParameterRefs.toString(this);
        }

        public int hashCode() {
            return ParameterRefs.hash(this);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ParameterRef && ParameterRefs.equals(this, (ParameterRef)o);
        }
    }

    private static class EmptyModifierParameterRef
    implements ParameterRef {
        private final TypeRef typeRef;
        private final Identifier name;

        private EmptyModifierParameterRef(TypeRef typeRef, Identifier name) {
            this.typeRef = typeRef;
            this.name = name;
        }

        public int hashCode() {
            return ParameterRefs.hash(this);
        }

        @Override
        public List<Modifier> getModifiers() {
            return ImmutableList.of();
        }

        public String toString() {
            return ParameterRefs.toString(this);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ParameterRef && ParameterRefs.equals(this, (ParameterRef)o);
        }

        @Override
        public TypeRef getType() {
            return this.typeRef;
        }

        @Override
        public Identifier getName() {
            return this.name;
        }
    }
}

