/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ForInit;
import apex.jorje.data.ast.ForInits;
import apex.jorje.data.ast.TypeRef;
import java.util.Optional;

public abstract class ForControl {
    private ForControl() {
    }

    public static final ForControl _EnhancedForControl(TypeRef type, ForInit init) {
        return new EnhancedForControl(type, init);
    }

    public static final ForControl _CStyleForControl(Optional<ForInits> inits, Optional<Expr> condition, Optional<Expr> control) {
        return new CStyleForControl(inits, condition, control);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class CStyleForControl
    extends ForControl {
        public Optional<ForInits> inits;
        public Optional<Expr> condition;
        public Optional<Expr> control;

        public CStyleForControl(Optional<ForInits> inits, Optional<Expr> condition, Optional<Expr> control) {
            this.inits = inits;
            this.condition = condition;
            this.control = control;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inits == null ? 0 : this.inits.hashCode());
            result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
            result = 31 * result + (this.control == null ? 0 : this.control.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CStyleForControl other = (CStyleForControl)obj;
            if (this.inits == null ? other.inits != null : !this.inits.equals(other.inits)) {
                return false;
            }
            if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
                return false;
            }
            return !(this.control == null ? other.control != null : !this.control.equals(other.control));
        }

        public String toString() {
            return "CStyleForControl(inits = " + this.inits + ", condition = " + this.condition + ", control = " + this.control + ")";
        }
    }

    public static final class EnhancedForControl
    extends ForControl {
        public TypeRef type;
        public ForInit init;

        public EnhancedForControl(TypeRef type, ForInit init) {
            this.type = type;
            this.init = init;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.init == null ? 0 : this.init.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnhancedForControl other = (EnhancedForControl)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.init == null ? other.init != null : !this.init.equals(other.init));
        }

        public String toString() {
            return "EnhancedForControl(type = " + this.type + ", init = " + this.init + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(EnhancedForControl x) {
            this._default(x);
        }

        @Override
        public void _case(CStyleForControl x) {
            this._default(x);
        }

        protected abstract void _default(ForControl var1);
    }

    public static interface SwitchBlock {
        public void _case(EnhancedForControl var1);

        public void _case(CStyleForControl var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(EnhancedForControl x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(CStyleForControl x) {
            return this._default(x);
        }

        protected abstract ResultType _default(ForControl var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(EnhancedForControl var1);

        public ResultType _case(CStyleForControl var1);
    }
}

