/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Optional;

public class TypeRefBuilder {
    private final List<Identifier> names;
    private List<TypeRef> argumentTypes;
    private boolean isJavaType;
    private int index;

    private TypeRefBuilder(int index, List<Identifier> names) {
        this.index = index;
        this.names = names;
        this.argumentTypes = ImmutableList.of();
    }

    public static TypeRef type(String name) {
        Preconditions.checkArgument(!name.contains("."), "type refs must be split across DOT");
        return TypeRefBuilder.type(0, name);
    }

    public static TypeRef type(int start, String name) {
        return new TypeRefBuilder(start, ImmutableList.of(JadtTester.identifier(start, name))).build();
    }

    public static Optional<TypeRef> optionalType(int start, String name) {
        return Optional.of(TypeRefBuilder.type(start, name));
    }

    public static TypeRefBuilder withNames(String ... names) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String name : names) {
            builder.add(Identifiers.newIdentifier(name));
        }
        return new TypeRefBuilder(0, (List<Identifier>)((Object)builder.build()));
    }

    public static TypeRefBuilder withNames(int start, String ... names) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int index = start;
        for (String name : names) {
            builder.add(JadtTester.identifier(index, name));
            index += 1 + name.length();
        }
        return new TypeRefBuilder(index, (List<Identifier>)((Object)builder.build()));
    }

    public static TypeRef list(TypeRef element) {
        return TypeRefBuilder.withNames("List").withArgumentTypes(element).build();
    }

    public TypeRef build() {
        if (this.isJavaType) {
            assert (this.argumentTypes.isEmpty()) : "java types cannot have type arguments";
            return TypeRefs.newJavaTypeRef(this.names);
        }
        return TypeRefs.newClassTypeRef(this.names, this.argumentTypes);
    }

    public TypeRefBuilder asJavaRef() {
        this.isJavaType = true;
        return this;
    }

    public TypeRefBuilder withArgumentTypes(String ... argumentTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String argumentType : argumentTypes) {
            builder.add(TypeRefBuilder.type(this.index, argumentType));
            this.index += 1 + argumentType.length();
        }
        this.argumentTypes = builder.build();
        return this;
    }

    public TypeRefBuilder withArgumentTypes(TypeRef ... argumentTypes) {
        this.argumentTypes = MoreLists.asImmutableList(argumentTypes);
        return this;
    }
}

