/*
 * Decompiled with CFR 0.152.
 */
package apex.common.collect;

import java.util.Comparator;
import java.util.List;

public class Comparators {
    public static <T> int compare(T left, T right, Comparator<T> comparator) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return comparator.compare(left, right);
    }

    public static <T> boolean isLessThan(T left, T right, Comparator<T> comparator) {
        return Comparators.compare(left, right, comparator) < 0;
    }

    public static <T> boolean isGreaterThan(T left, T right, Comparator<T> comparator) {
        return Comparators.compare(left, right, comparator) > 0;
    }

    public static <T> boolean isEqualTo(T left, T right, Comparator<T> comparator) {
        return Comparators.compare(left, right, comparator) == 0;
    }

    public static <T> int compare(List<T> left, List<T> right, Comparator<T> comparator) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left.size() != right.size()) {
            return right.size() - left.size();
        }
        for (int i = 0; i < left.size(); ++i) {
            int retVal = Comparators.compare(left.get(i), right.get(i), comparator);
            if (retVal == 0) continue;
            return retVal;
        }
        return 0;
    }

    public static <T> int compare(T[] left, T[] right, Comparator<T> comparator) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left.length != right.length) {
            return right.length - left.length;
        }
        for (int i = 0; i < left.length; ++i) {
            int retVal = Comparators.compare(left[i], right[i], comparator);
            if (retVal == 0) continue;
            return retVal;
        }
        return 0;
    }
}

