/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class TooManyFieldsRule
extends AbstractApexRule {
    private static final int DEFAULT_MAXFIELDS = 15;
    private static final PropertyDescriptor<Integer> MAX_FIELDS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxfields").desc("Max allowable fields")).defaultValue((Object)15)).require(NumericConstraints.positive())).build();

    public TooManyFieldsRule() {
        this.definePropertyDescriptor(MAX_FIELDS_DESCRIPTOR);
        this.addRuleChainVisit(ASTUserClass.class);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Complexity"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 200);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        List fields = node.findChildrenOfType(ASTField.class);
        int val = 0;
        for (ASTField field : fields) {
            if (field.getModifiers().isFinal() && field.getModifiers().isStatic()) continue;
            ++val;
        }
        if (val > (Integer)this.getProperty(MAX_FIELDS_DESCRIPTOR)) {
            this.addViolation(data, node);
        }
        return data;
    }
}

