/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.codestyle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;

public class FieldDeclarationsShouldBeAtStartRule
extends AbstractApexRule {
    private static final Comparator<ApexNode<?>> NODE_BY_SOURCE_LOCATION_COMPARATOR = Comparator.comparingInt(Node::getBeginLine).thenComparing(Node::getBeginColumn);
    public static final String STATIC_INITIALIZER_METHOD_NAME = "<clinit>";

    public FieldDeclarationsShouldBeAtStartRule() {
        this.addRuleChainVisit(ASTUserClass.class);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        List fields = node.findChildrenOfType(ASTField.class);
        ArrayList nonFieldDeclarations = new ArrayList();
        nonFieldDeclarations.addAll(this.getMethodNodes(node));
        nonFieldDeclarations.addAll(node.findChildrenOfType(ASTUserClass.class));
        nonFieldDeclarations.addAll(node.findChildrenOfType(ASTProperty.class));
        nonFieldDeclarations.addAll(node.findChildrenOfType(ASTBlockStatement.class));
        Optional<ApexNode<?>> firstNonFieldDeclaration = nonFieldDeclarations.stream().filter(ApexNode::hasRealLoc).min(NODE_BY_SOURCE_LOCATION_COMPARATOR);
        if (!firstNonFieldDeclaration.isPresent()) {
            return data;
        }
        for (ASTField field : fields) {
            if (NODE_BY_SOURCE_LOCATION_COMPARATOR.compare(field, firstNonFieldDeclaration.get()) <= 0) continue;
            this.addViolation(data, field, field.getName());
        }
        return data;
    }

    private List<ApexNode<?>> getMethodNodes(ASTUserClass node) {
        return node.findChildrenOfType(ASTMethod.class).stream().flatMap(method -> STATIC_INITIALIZER_METHOD_NAME.equals(method.getImage()) ? method.findChildrenOfType(ASTBlockStatement.class).stream() : Stream.of(method)).collect(Collectors.toList());
    }
}

