/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class SimplifiableTestAssertionRule
extends AbstractJavaRule {
    private final Set<String> importedMethodsHere = new HashSet<String>();
    private boolean allAssertionsOn;

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.importedMethodsHere.clear();
        this.allAssertionsOn = false;
        for (ASTImportDeclaration importDecl : node.findChildrenOfType(ASTImportDeclaration.class)) {
            if (!importDecl.isStatic()) continue;
            if (importDecl.isImportOnDemand()) {
                if (!this.isAssertionContainer(importDecl.getImportedName())) continue;
                this.allAssertionsOn = true;
                continue;
            }
            this.checkImportedAssertion(importDecl.getImportedName());
        }
        super.visit(node, data);
        return null;
    }

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        ASTArgumentList argList;
        boolean isAssertTrue = this.isAssertionCall(node, "assertTrue");
        boolean isAssertFalse = this.isAssertionCall(node, "assertFalse");
        if (isAssertTrue || isAssertFalse) {
            String suggestion;
            ASTArgumentList args = this.getNonEmptyArgList(node);
            JavaNode lastArg = SimplifiableTestAssertionRule.getChildRev(args, -1);
            ASTEqualityExpression eq = this.asEqualityExpr(lastArg);
            if (eq != null) {
                boolean isPositive;
                boolean bl = isPositive = this.isPositiveEqualityExpr(eq) == isAssertTrue;
                suggestion = SimplifiableTestAssertionRule.isNullLiteral((JavaNode)eq.getChild(0)) || SimplifiableTestAssertionRule.isNullLiteral((JavaNode)eq.getChild(1)) ? (isPositive ? "assertNull" : "assertNonNull") : (this.isPrimitive((JavaNode)eq.getChild(0)) || this.isPrimitive((JavaNode)eq.getChild(1)) ? (isPositive ? "assertEquals" : "assertNotEquals") : (isPositive ? "assertSame" : "assertNotSame"));
                this.addViolation(data, (Node)node, suggestion);
            } else {
                JavaNode negatedExprOperand = SimplifiableTestAssertionRule.getNegatedExprOperand(lastArg);
                if (SimplifiableTestAssertionRule.isCall(negatedExprOperand, "equals")) {
                    suggestion = isAssertTrue ? "assertNotEquals" : "assertEquals";
                    this.addViolation(data, (Node)node, suggestion);
                } else if (negatedExprOperand != null) {
                    suggestion = isAssertTrue ? "assertFalse" : "assertTrue";
                    this.addViolation(data, (Node)node, suggestion);
                } else if (SimplifiableTestAssertionRule.isCall(lastArg, "equals")) {
                    suggestion = isAssertTrue ? "assertEquals" : "assertNotEquals";
                    this.addViolation(data, (Node)node, suggestion);
                }
            }
        }
        boolean isAssertEquals = this.isAssertionCall(node, "assertEquals");
        boolean isAssertNotEquals = this.isAssertionCall(node, "assertNotEquals");
        if ((isAssertEquals || isAssertNotEquals) && (argList = this.getNonEmptyArgList(node)) != null && argList.size() >= 2) {
            JavaNode comp0 = SimplifiableTestAssertionRule.getChildRev(argList, -1);
            JavaNode comp1 = SimplifiableTestAssertionRule.getChildRev(argList, -2);
            if (SimplifiableTestAssertionRule.isBooleanLiteral(comp0) ^ SimplifiableTestAssertionRule.isBooleanLiteral(comp1)) {
                if (SimplifiableTestAssertionRule.isBooleanLiteral(comp1)) {
                    JavaNode tmp = comp0;
                    comp0 = comp1;
                    comp1 = tmp;
                }
                if (comp1 instanceof TypeNode && TypeTestUtil.isA(Boolean.TYPE, (TypeNode)comp1)) {
                    ASTBooleanLiteral literal = (ASTBooleanLiteral)SimplifiableTestAssertionRule.unwrapLiteral(comp0);
                    String suggestion = literal.isTrue() == isAssertEquals ? "assertTrue" : "assertFalse";
                    this.addViolation(data, (Node)node, suggestion);
                }
            }
        }
        return super.visit(node, data);
    }

    private boolean isPrimitive(JavaNode node) {
        if (node instanceof TypeNode) {
            Class<?> t0 = ((TypeNode)node).getType();
            return t0 != null && t0.isPrimitive();
        }
        return false;
    }

    private static JavaNode getChildRev(JavaNode list, int i) {
        assert (i < 0) : "Expecting negative offset";
        return list == null ? null : list.getChild(list.getNumChildren() + i);
    }

    private static boolean isCall(JavaNode node, String methodName) {
        if (node instanceof ASTExpression) {
            if (node.getNumChildren() == 1) {
                node = node.getChild(0);
            } else {
                return false;
            }
        }
        if (!(node instanceof ASTPrimaryExpression) || node.getNumChildren() < 2) {
            return false;
        }
        JavaNode prefix = SimplifiableTestAssertionRule.getChildRev(node, -2);
        JavaNode suffix = SimplifiableTestAssertionRule.getChildRev(node, -1);
        if (!(suffix instanceof ASTPrimarySuffix) || !((ASTPrimarySuffix)suffix).isArguments()) {
            return false;
        }
        if (prefix instanceof ASTPrimaryPrefix && prefix.getNumChildren() > 0 && prefix.getChild(0) instanceof ASTName) {
            String image = prefix.getChild(0).getImage();
            return SimplifiableTestAssertionRule.isPossiblyQualifiedMethodName(methodName, image);
        }
        if (prefix instanceof ASTPrimarySuffix) {
            return methodName.equals(prefix.getImage());
        }
        return false;
    }

    private boolean isAssertionCall(JavaNode node, String methodName) {
        if (node instanceof ASTExpression) {
            if (node.getNumChildren() == 1) {
                node = node.getChild(0);
            } else {
                return false;
            }
        }
        if (node.getNumChildren() != 2 || !SimplifiableTestAssertionRule.isCall(node, methodName)) {
            return false;
        }
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)SimplifiableTestAssertionRule.getChildRev(node, -2);
        return this.isAssertionMethodName(methodName, (ASTName)prefix.getChild(0));
    }

    private static boolean isPossiblyQualifiedMethodName(String methodName, String possiblyQualifiedName) {
        return methodName.equals(possiblyQualifiedName) || possiblyQualifiedName.length() > methodName.length() && possiblyQualifiedName.endsWith(methodName) && possiblyQualifiedName.charAt(possiblyQualifiedName.length() - methodName.length() - 1) == '.';
    }

    private boolean isAssertionMethodName(String methodName, ASTName location) {
        String possiblyQualifiedName = location.getImage();
        if (methodName.equals(possiblyQualifiedName)) {
            return this.allAssertionsOn || this.importedMethodsHere.contains(methodName) || TypeTestUtil.isA("junit.framework.TestCase", (TypeNode)location.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class));
        }
        if (possiblyQualifiedName.length() > methodName.length() && possiblyQualifiedName.endsWith(methodName) && possiblyQualifiedName.charAt(possiblyQualifiedName.length() - methodName.length() - 1) == '.') {
            return TypeTestUtil.isA("org.junit.jupiter.api.Assertions", (TypeNode)location) || TypeTestUtil.isA("org.junit.Assert", (TypeNode)location);
        }
        return false;
    }

    private ASTArgumentList getNonEmptyArgList(ASTPrimaryExpression node) {
        ASTPrimarySuffix suffix = (ASTPrimarySuffix)node.getFirstChildOfType(ASTPrimarySuffix.class);
        if (suffix != null && suffix.isArguments() && suffix.getArgumentCount() > 0) {
            return (ASTArgumentList)((JavaNode)suffix.getChild(0)).getChild(0);
        }
        return null;
    }

    private ASTEqualityExpression asEqualityExpr(JavaNode node) {
        if (node instanceof ASTExpression) {
            if (node.getNumChildren() == 1) {
                node = node.getChild(0);
            } else {
                return null;
            }
        }
        return node instanceof ASTEqualityExpression ? (ASTEqualityExpression)node : null;
    }

    private boolean isPositiveEqualityExpr(ASTEqualityExpression node) {
        return node != null && node.getOperator().equals("==");
    }

    private static JavaNode getNegatedExprOperand(JavaNode node) {
        if (node instanceof ASTExpression) {
            if (node.getNumChildren() == 1) {
                node = node.getChild(0);
            } else {
                return null;
            }
        }
        if (node instanceof ASTUnaryExpressionNotPlusMinus && "!".equals(((ASTUnaryExpressionNotPlusMinus)node).getOperator())) {
            return node.getChild(0);
        }
        return null;
    }

    private static boolean isNullLiteral(JavaNode node) {
        return SimplifiableTestAssertionRule.unwrapLiteral(node) instanceof ASTNullLiteral;
    }

    private static boolean isBooleanLiteral(JavaNode node) {
        return SimplifiableTestAssertionRule.unwrapLiteral(node) instanceof ASTBooleanLiteral;
    }

    private static JavaNode unwrapLiteral(JavaNode node) {
        if (node instanceof ASTExpression) {
            if (node.getNumChildren() == 1) {
                node = node.getChild(0);
            } else {
                return null;
            }
        }
        if (node instanceof ASTPrimaryExpression) {
            if (node.getNumChildren() == 1) {
                node = node.getChild(0);
            } else {
                return null;
            }
        }
        if (node instanceof ASTPrimaryPrefix) {
            if (node.getNumChildren() == 1) {
                node = node.getChild(0);
            } else {
                return null;
            }
        }
        if (node instanceof ASTLiteral) {
            if (node.getNumChildren() == 1) {
                node = node.getChild(0);
            } else {
                return null;
            }
        }
        return node;
    }

    private boolean isAssertionContainer(String importedName) {
        return "org.junit.jupiter.api.Assertions".equals(importedName) || "org.junit.Assert".equals(importedName);
    }

    private void checkImportedAssertion(String importedName) {
        String stripped = SimplifiableTestAssertionRule.removePrefixOrNull(importedName, "org.junit.jupiter.api.Assertions.");
        if (stripped == null) {
            stripped = SimplifiableTestAssertionRule.removePrefixOrNull(importedName, "org.junit.Assert.");
        }
        if (stripped != null && stripped.indexOf(46) == -1) {
            this.importedMethodsHere.add(stripped);
        }
    }

    private static String removePrefixOrNull(String str, String prefix) {
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return null;
    }
}

