/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver;

import net.sourceforge.pmd.lang.modelica.ast.ASTStoredDefinition;
import net.sourceforge.pmd.lang.modelica.resolver.AbstractModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.CompositeName;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionContext;
import net.sourceforge.pmd.lang.modelica.resolver.ResolvableEntity;
import net.sourceforge.pmd.lang.modelica.resolver.Watchdog;

public final class ModelicaSourceFileScope
extends AbstractModelicaScope {
    private final String fileFQCN;
    private final String[] packageComponents;

    ModelicaSourceFileScope(ASTStoredDefinition node) {
        this.fileFQCN = node.getImage();
        this.packageComponents = this.fileFQCN.isEmpty() ? new String[0] : this.fileFQCN.split("\\.");
    }

    void lookupLocally(ResolutionContext result, CompositeName name) throws Watchdog.CountdownException {
        if (name.isEmpty()) {
            return;
        }
        result.watchdogTick();
        String firstName = name.getHead();
        CompositeName furtherNames = name.getTail();
        for (ModelicaDeclaration decl : this.getDirectlyDeclared(firstName)) {
            ResolutionContext tmpContext = result.getState().createContext();
            ((ModelicaClassDeclaration)decl).lookupInInstanceScope(result, furtherNames);
            result.accumulate(tmpContext.get(ResolvableEntity.class));
        }
    }

    void lookupGlobally(ResolutionContext result, CompositeName name) throws Watchdog.CountdownException {
        result.watchdogTick();
        CompositeName remainingNameComponents = name.matchPrefix(this.packageComponents);
        if (remainingNameComponents != null) {
            this.lookupLocally(result, remainingNameComponents);
        }
    }

    @Override
    public void resolveLexically(ResolutionContext result, CompositeName name) throws Watchdog.CountdownException {
        if (!this.isInDefaultPackage()) {
            this.lookupLocally(result, name);
        }
        ((AbstractModelicaScope)this.getParent()).resolveLexically(result, name);
    }

    @Override
    public String getRepresentation() {
        return "FILE";
    }

    public boolean isInDefaultPackage() {
        return this.fileFQCN.isEmpty();
    }

    public String getFileFQCN() {
        return this.fileFQCN;
    }
}

