/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class HTMLRenderer
extends AbstractIncrementingRenderer {
    public static final String NAME = "html";
    public static final StringProperty LINE_PREFIX = new StringProperty("linePrefix", "Prefix for line number anchor in the source file.", null, 1.0f);
    public static final StringProperty LINK_PREFIX = new StringProperty("linkPrefix", "Path to HTML source.", null, 0.0f);
    public static final PropertyDescriptor<Boolean> HTML_EXTENSION = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty("htmlExtension").desc("Replace file extension with .html for the links (default: false)")).defaultValue(false)).build();
    private String linkPrefix;
    private String linePrefix;
    private boolean replaceHtmlExtension;
    private int violationCount = 1;
    boolean colorize = true;

    public HTMLRenderer() {
        super(NAME, "HTML format");
        this.definePropertyDescriptor(LINK_PREFIX);
        this.definePropertyDescriptor(LINE_PREFIX);
        this.definePropertyDescriptor(HTML_EXTENSION);
    }

    @Override
    public String defaultFileExtension() {
        return NAME;
    }

    public void renderBody(Writer writer, Report report) throws IOException {
        this.linkPrefix = this.getProperty(LINK_PREFIX);
        this.linePrefix = this.getProperty(LINE_PREFIX);
        this.replaceHtmlExtension = this.getProperty(HTML_EXTENSION);
        writer.write("<center><h3>PMD report</h3></center>");
        writer.write("<center><h3>Problems found</h3></center>");
        writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>#</th><th>File</th><th>Line</th><th>Problem</th></tr>" + PMD.EOL);
        this.setWriter(writer);
        this.renderFileReport(report);
        writer.write("</table>");
        this.glomProcessingErrors(writer, this.errors);
        if (this.showSuppressedViolations) {
            this.glomSuppressions(writer, this.suppressed);
        }
        this.glomConfigurationErrors(writer, this.configErrors);
    }

    @Override
    public void start() throws IOException {
        this.linkPrefix = this.getProperty(LINK_PREFIX);
        this.linePrefix = this.getProperty(LINE_PREFIX);
        this.replaceHtmlExtension = this.getProperty(HTML_EXTENSION);
        this.writer.write("<html><head><title>PMD</title></head><body>" + PMD.EOL);
        this.writer.write("<center><h3>PMD report</h3></center>");
        this.writer.write("<center><h3>Problems found</h3></center>");
        this.writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>#</th><th>File</th><th>Line</th><th>Problem</th></tr>" + PMD.EOL);
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        this.glomRuleViolations(this.writer, violations);
    }

    @Override
    public void end() throws IOException {
        this.writer.write("</table>");
        this.glomProcessingErrors(this.writer, this.errors);
        if (this.showSuppressedViolations) {
            this.glomSuppressions(this.writer, this.suppressed);
        }
        this.glomConfigurationErrors(this.writer, this.configErrors);
        this.writer.write("</body></html>" + PMD.EOL);
    }

    private void glomRuleViolations(Writer writer, Iterator<RuleViolation> violations) throws IOException {
        StringBuilder buf = new StringBuilder(500);
        while (violations.hasNext()) {
            RuleViolation rv = violations.next();
            buf.setLength(0);
            buf.append("<tr");
            if (this.colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
            }
            this.colorize = !this.colorize;
            buf.append("> ").append(PMD.EOL);
            buf.append("<td align=\"center\">").append(this.violationCount).append("</td>").append(PMD.EOL);
            buf.append("<td width=\"*%\">").append(this.renderFileName(rv.getFilename(), rv.getBeginLine())).append("</td>").append(PMD.EOL);
            buf.append("<td align=\"center\" width=\"5%\">").append(rv.getBeginLine()).append("</td>").append(PMD.EOL);
            String d = StringEscapeUtils.escapeHtml4((String)rv.getDescription());
            String infoUrl = rv.getRule().getExternalInfoUrl();
            if (StringUtils.isNotBlank((CharSequence)infoUrl)) {
                d = "<a href=\"" + infoUrl + "\">" + d + "</a>";
            }
            buf.append("<td width=\"*\">").append(d).append("</td>").append(PMD.EOL);
            buf.append("</tr>").append(PMD.EOL);
            writer.write(buf.toString());
            ++this.violationCount;
        }
    }

    private String renderFileName(String filename, int beginLine) {
        return this.maybeWrap(StringEscapeUtils.escapeHtml4((String)this.determineFileName(filename)), this.linePrefix == null || beginLine < 0 ? "" : this.linePrefix + beginLine);
    }

    private String renderRuleName(Rule rule) {
        String name = rule.getName();
        String infoUrl = rule.getExternalInfoUrl();
        if (StringUtils.isNotBlank((CharSequence)infoUrl)) {
            return "<a href=\"" + infoUrl + "\">" + name + "</a>";
        }
        return name;
    }

    private void glomProcessingErrors(Writer writer, List<Report.ProcessingError> errors) throws IOException {
        if (errors.isEmpty()) {
            return;
        }
        writer.write("<hr/>");
        writer.write("<center><h3>Processing errors</h3></center>");
        writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>File</th><th>Problem</th></tr>" + PMD.EOL);
        StringBuilder buf = new StringBuilder(500);
        boolean colorize = true;
        for (Report.ProcessingError pe : errors) {
            buf.setLength(0);
            buf.append("<tr");
            if (colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
            }
            colorize = !colorize;
            buf.append("> ").append(PMD.EOL);
            buf.append("<td>").append(this.renderFileName(pe.getFile(), -1)).append("</td>").append(PMD.EOL);
            buf.append("<td><pre>").append(pe.getDetail()).append("</pre></td>").append(PMD.EOL);
            buf.append("</tr>").append(PMD.EOL);
            writer.write(buf.toString());
        }
        writer.write("</table>");
    }

    private void glomSuppressions(Writer writer, List<Report.SuppressedViolation> suppressed) throws IOException {
        if (suppressed.isEmpty()) {
            return;
        }
        writer.write("<hr/>");
        writer.write("<center><h3>Suppressed warnings</h3></center>");
        writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>File</th><th>Line</th><th>Rule</th><th>NOPMD or Annotation</th><th>Reason</th></tr>" + PMD.EOL);
        StringBuilder buf = new StringBuilder(500);
        boolean colorize = true;
        for (Report.SuppressedViolation sv : suppressed) {
            buf.setLength(0);
            buf.append("<tr");
            if (colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
            }
            colorize = !colorize;
            buf.append("> ").append(PMD.EOL);
            RuleViolation rv = sv.getRuleViolation();
            buf.append("<td align=\"left\">").append(this.renderFileName(rv.getFilename(), rv.getBeginLine())).append("</td>").append(PMD.EOL);
            buf.append("<td align=\"center\">").append(rv.getBeginLine()).append("</td>").append(PMD.EOL);
            buf.append("<td align=\"center\">").append(this.renderRuleName(rv.getRule())).append("</td>").append(PMD.EOL);
            buf.append("<td align=\"center\">").append(sv.suppressedByNOPMD() ? "NOPMD" : "Annotation").append("</td>").append(PMD.EOL);
            buf.append("<td align=\"center\">").append(sv.getUserMessage() == null ? "" : sv.getUserMessage()).append("</td>").append(PMD.EOL);
            buf.append("</tr>").append(PMD.EOL);
            writer.write(buf.toString());
        }
        writer.write("</table>");
    }

    private void glomConfigurationErrors(Writer writer, List<Report.ConfigurationError> configErrors) throws IOException {
        if (configErrors.isEmpty()) {
            return;
        }
        writer.write("<hr/>");
        writer.write("<center><h3>Configuration errors</h3></center>");
        writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>Rule</th><th>Problem</th></tr>" + PMD.EOL);
        StringBuilder buf = new StringBuilder(500);
        boolean colorize = true;
        for (Report.ConfigurationError ce : configErrors) {
            buf.setLength(0);
            buf.append("<tr");
            if (colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
            }
            colorize = !colorize;
            buf.append("> ").append(PMD.EOL);
            buf.append("<td>").append(this.renderRuleName(ce.rule())).append("</td>").append(PMD.EOL);
            buf.append("<td>").append(ce.issue()).append("</td>").append(PMD.EOL);
            buf.append("</tr>").append(PMD.EOL);
            writer.write(buf.toString());
        }
        writer.write("</table>");
    }

    private String maybeWrap(String filename, String line) {
        int index;
        if (StringUtils.isBlank((CharSequence)this.linkPrefix)) {
            return filename;
        }
        String newFileName = filename.replace('\\', '/');
        if (this.replaceHtmlExtension && (index = filename.lastIndexOf(46)) >= 0) {
            newFileName = filename.substring(0, index);
        }
        return "<a href=\"" + this.linkPrefix + newFileName + (this.replaceHtmlExtension ? ".html#" : "#") + line + "\">" + newFileName + "</a>";
    }
}

