/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.common.base.Result;
import apex.common.tuple.MultiKeyPair;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldSupplier;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DynamicFieldTable
implements FieldTable {
    private final FieldSupplier supplier;
    private final Map<MultiKeyPair, FieldInfo> fields;

    public DynamicFieldTable(FieldSupplier supplier) {
        this.supplier = supplier;
        this.fields = new HashMap<MultiKeyPair, FieldInfo>();
    }

    @Override
    public Result<Void> add(FieldInfo field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldInfo get(SymbolResolver symbols, TypeInfo referencingType, String name, FieldTable.LookupMode mode) {
        String lowerCaseFieldName = name.toLowerCase();
        MultiKeyPair key = MultiKeyPair.multiKey(lowerCaseFieldName, referencingType.getBytecodeName());
        FieldInfo field = this.fields.get(key);
        if (field == null && (field = this.supplier.get(symbols, referencingType, name)) != null) {
            this.fields.put(key, field);
        }
        return field;
    }

    @Override
    public FieldTable resolve() {
        return this;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public Collection<FieldInfo> all() {
        throw new UnsupportedOperationException();
    }
}

