/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BindExpression;
import apex.jorje.semantic.ast.expression.BindExpressions;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.QueryNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SearchEmitMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.PrinterUtil;
import java.util.List;

public class SoslExpression
extends Expression
implements QueryNode {
    private final Location loc;
    private final String query;
    private final BindExpressions bindExpression;
    private final String canonicalQuery;

    public SoslExpression(AstNode definingNode, Expr.SoslExpr x) {
        super(definingNode);
        this.loc = x.loc;
        this.query = x.rawQuery;
        PrintContext ctx = PrintContexts.standard();
        this.canonicalQuery = this.print(x, ctx);
        this.bindExpression = new BindExpressions(this, ctx.getBindExprs());
    }

    private String print(Expr.SoslExpr expr, PrintContext ctx) {
        try {
            PrinterFactory factory = PrinterUtil.get().getFactory();
            return factory.searchPrinter().print(expr.search, ctx);
        }
        catch (NullPointerException x) {
            return "";
        }
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.bindExpression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.bindExpression.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.bindExpression) || this.query.isEmpty()) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.setType(ReifiedTypeInfos.SOBJECT_LIST_LIST);
        String realQuery = symbols.getQueryValidator().validateSosl(symbols, scope, this);
        if (realQuery.length() >= 65536) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("query.too.large"));
        }
        this.bindExpression.setQuery(realQuery);
    }

    @Override
    public void emit(Emitter emitter) {
        this.bindExpression.emit(emitter);
        ProfilingType.SOSL.emit(emitter, this.loc, this.query);
        emitter.emit(this.loc, SearchEmitMethods.QUERY_MAP);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    @Override
    public String getRawQuery() {
        assert (this.query.endsWith("]") && this.query.startsWith("[")) : "query is malformed: " + this.query;
        return this.query.substring(1, this.query.length() - 1);
    }

    @Override
    public String getCanonicalQuery() {
        return this.canonicalQuery;
    }

    @Override
    public List<BindExpression> getBindExpressions() {
        return this.bindExpression.getBindExpressions();
    }
}

