/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.typings;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.document.DocumentLifecycleHandler;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.api.workspace.WorkspaceChangeListener;
import apex.jorje.lsp.impl.clients.VSCode;
import apex.jorje.lsp.impl.index.ApexIndexer;
import apex.jorje.lsp.impl.index.SfdxProject;
import apex.jorje.lsp.impl.typings.TypeDefinitionGenerator;
import apex.jorje.lsp.impl.typings.TypeDefinitionModule;
import apex.jorje.lsp.impl.typings.TypeDefinitionWriter;
import apex.jorje.lsp.impl.utils.SfdxProjects;
import com.google.common.collect.Queues;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.FileEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TypeDefinitionLifecycleHandler
implements DocumentLifecycleHandler,
WorkspaceChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionLifecycleHandler.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final TypeDefinitionWriter typeDefinitionWriter;
    private final SfdxProjects sfdxProjects;

    @Inject
    public TypeDefinitionLifecycleHandler(ApexCompilerService compilerService, ApexDocumentService documentService, TypeDefinitionWriter typeDefinitionWriter, SfdxProjects sfdxProjects) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.typeDefinitionWriter = typeDefinitionWriter;
        this.sfdxProjects = sfdxProjects;
    }

    @Override
    public void handleDidOpen(DidOpenTextDocumentParams params) {
    }

    @Override
    public void handleDidChange(DidChangeTextDocumentParams params) {
        Optional<Document> document = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        this.generateTypeDefinitionsIfApplicable(document);
    }

    @Override
    public void handleDidClose(DidCloseTextDocumentParams params) {
    }

    @Override
    public void handleDidSave(DidSaveTextDocumentParams params) {
        Optional<Document> document = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        this.generateTypeDefinitionsIfApplicable(document);
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams didChangeConfigurationParams) {
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams didChangeWatchedFilesParams) {
        ConcurrentLinkedQueue<FileEvent> fileEvents = Queues.newConcurrentLinkedQueue();
        fileEvents.addAll(VSCode.standardizeFileEvents(didChangeWatchedFilesParams.getChanges()));
        while (!fileEvents.isEmpty()) {
            FileEvent change = (FileEvent)fileEvents.remove();
            String uri = change.getUri();
            Path path = Paths.get(URI.create(uri));
            if (!ApexIndexer.CLS_MATCHER.matches(path)) continue;
            switch (change.getType()) {
                case Created: {
                    if (!this.isValidClass(path)) break;
                    Optional<Document> document = this.documentService.retrieve(URI.create(uri));
                    this.generateTypeDefinitionsIfApplicable(document);
                    break;
                }
                case Changed: {
                    if (!this.isValidClass(path)) break;
                    Optional<Document> document = this.documentService.retrieve(URI.create(uri));
                    this.generateTypeDefinitionsIfApplicable(document);
                    break;
                }
                case Deleted: {
                    if (!this.isValidClass(path)) break;
                    this.deleteTypeDefinition(path);
                }
            }
        }
    }

    private void deleteTypeDefinition(Path path) {
        String possibleTypeDefinitionFileName = TypeDefinitionGenerator.generateTypeDefinitionFileName(com.google.common.io.Files.getNameWithoutExtension(path.getFileName().toString()));
        Path possibleTypeDefinitionPath = this.typeDefinitionWriter.getApexTypingsFolder().resolve(possibleTypeDefinitionFileName);
        try {
            Files.delete(possibleTypeDefinitionPath);
        }
        catch (IOException ioe) {
            logger.warn("Could not delete type definition for accompanying Apex class {}", (Object)path.getFileName(), (Object)ioe);
        }
    }

    private synchronized boolean isUnderPackageDirectory(Path file) {
        Optional<SfdxProject> sfdxProject = this.sfdxProjects.constructSfdxProject();
        return sfdxProject.isPresent() && sfdxProject.get().isUnderPackageDirectory(file);
    }

    private synchronized boolean isValidClass(Path file) {
        return this.isUnderPackageDirectory(file);
    }

    private void generateTypeDefinitionsIfApplicable(Optional<Document> document) {
        document.ifPresent(doc -> {
            TypeDefinitionGenerator generator = new TypeDefinitionGenerator(this.compilerService, this.sfdxProjects, (Document)doc);
            Optional<TypeDefinitionModule> module = generator.buildModulesIfApplicable();
            if (module.isPresent()) {
                this.typeDefinitionWriter.writeModule(module.get());
            } else {
                this.deleteTypeDefinition(Paths.get(doc.getUri()));
            }
        });
    }
}

