/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.EnumDecl;
import apex.jorje.data.ast.InterfaceDecl;
import apex.jorje.data.ast.TriggerUsage;
import java.util.List;

public abstract class CompilationUnit {
    private static final CompilationUnit _InvalidDeclUnit = new InvalidDeclUnit();

    private CompilationUnit() {
    }

    public static final CompilationUnit _TriggerDeclUnit(Location loc, Identifier name, List<Identifier> target, boolean isBulk, List<TriggerUsage> usages, List<BlockMember> members) {
        return new TriggerDeclUnit(loc, name, target, isBulk, usages, members);
    }

    public static final CompilationUnit _AnonymousBlockUnit(List<BlockMember> members) {
        return new AnonymousBlockUnit(members);
    }

    public static final CompilationUnit _EnumDeclUnit(EnumDecl body) {
        return new EnumDeclUnit(body);
    }

    public static final CompilationUnit _ClassDeclUnit(ClassDecl body) {
        return new ClassDeclUnit(body);
    }

    public static final CompilationUnit _InterfaceDeclUnit(InterfaceDecl body) {
        return new InterfaceDeclUnit(body);
    }

    public static final CompilationUnit _InvalidDeclUnit() {
        return _InvalidDeclUnit;
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class InvalidDeclUnit
    extends CompilationUnit {
        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }

        public String toString() {
            return "InvalidDeclUnit";
        }
    }

    public static final class InterfaceDeclUnit
    extends CompilationUnit {
        public InterfaceDecl body;

        public InterfaceDeclUnit(InterfaceDecl body) {
            this.body = body;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InterfaceDeclUnit other = (InterfaceDeclUnit)obj;
            return !(this.body == null ? other.body != null : !this.body.equals(other.body));
        }

        public String toString() {
            return "InterfaceDeclUnit(body = " + this.body + ")";
        }
    }

    public static final class ClassDeclUnit
    extends CompilationUnit {
        public ClassDecl body;

        public ClassDeclUnit(ClassDecl body) {
            this.body = body;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassDeclUnit other = (ClassDeclUnit)obj;
            return !(this.body == null ? other.body != null : !this.body.equals(other.body));
        }

        public String toString() {
            return "ClassDeclUnit(body = " + this.body + ")";
        }
    }

    public static final class EnumDeclUnit
    extends CompilationUnit {
        public EnumDecl body;

        public EnumDeclUnit(EnumDecl body) {
            this.body = body;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumDeclUnit other = (EnumDeclUnit)obj;
            return !(this.body == null ? other.body != null : !this.body.equals(other.body));
        }

        public String toString() {
            return "EnumDeclUnit(body = " + this.body + ")";
        }
    }

    public static final class AnonymousBlockUnit
    extends CompilationUnit {
        public List<BlockMember> members;

        public AnonymousBlockUnit(List<BlockMember> members) {
            this.members = members;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnonymousBlockUnit other = (AnonymousBlockUnit)obj;
            return !(this.members == null ? other.members != null : !this.members.equals(other.members));
        }

        public String toString() {
            return "AnonymousBlockUnit(members = " + this.members + ")";
        }
    }

    public static final class TriggerDeclUnit
    extends CompilationUnit {
        public Location loc;
        public Identifier name;
        public List<Identifier> target;
        public boolean isBulk;
        public List<TriggerUsage> usages;
        public List<BlockMember> members;

        public TriggerDeclUnit(Location loc, Identifier name, List<Identifier> target, boolean isBulk, List<TriggerUsage> usages, List<BlockMember> members) {
            this.loc = loc;
            this.name = name;
            this.target = target;
            this.isBulk = isBulk;
            this.usages = usages;
            this.members = members;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            result = 31 * result + (this.isBulk ? 1 : 0);
            result = 31 * result + (this.usages == null ? 0 : this.usages.hashCode());
            result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TriggerDeclUnit other = (TriggerDeclUnit)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
                return false;
            }
            if (this.isBulk != other.isBulk) {
                return false;
            }
            if (this.usages == null ? other.usages != null : !this.usages.equals(other.usages)) {
                return false;
            }
            return !(this.members == null ? other.members != null : !this.members.equals(other.members));
        }

        public String toString() {
            return "TriggerDeclUnit(loc = " + this.loc + ", name = " + this.name + ", target = " + this.target + ", isBulk = " + this.isBulk + ", usages = " + this.usages + ", members = " + this.members + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(TriggerDeclUnit x) {
            this._default(x);
        }

        @Override
        public void _case(AnonymousBlockUnit x) {
            this._default(x);
        }

        @Override
        public void _case(EnumDeclUnit x) {
            this._default(x);
        }

        @Override
        public void _case(ClassDeclUnit x) {
            this._default(x);
        }

        @Override
        public void _case(InterfaceDeclUnit x) {
            this._default(x);
        }

        @Override
        public void _case(InvalidDeclUnit x) {
            this._default(x);
        }

        protected abstract void _default(CompilationUnit var1);
    }

    public static interface SwitchBlock {
        public void _case(TriggerDeclUnit var1);

        public void _case(AnonymousBlockUnit var1);

        public void _case(EnumDeclUnit var1);

        public void _case(ClassDeclUnit var1);

        public void _case(InterfaceDeclUnit var1);

        public void _case(InvalidDeclUnit var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(TriggerDeclUnit x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(AnonymousBlockUnit x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(EnumDeclUnit x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ClassDeclUnit x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(InterfaceDeclUnit x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(InvalidDeclUnit x) {
            return this._default(x);
        }

        protected abstract ResultType _default(CompilationUnit var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(TriggerDeclUnit var1);

        public ResultType _case(AnonymousBlockUnit var1);

        public ResultType _case(EnumDeclUnit var1);

        public ResultType _case(ClassDeclUnit var1);

        public ResultType _case(InterfaceDeclUnit var1);

        public ResultType _case(InvalidDeclUnit var1);
    }
}

