/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimsAndInits;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class PrimitiveWrapperInstantiationRule
extends AbstractJavaRule {
    public PrimitiveWrapperInstantiationRule() {
        this.addRuleChainVisit(ASTAllocationExpression.class);
        this.addRuleChainVisit(ASTPrimaryExpression.class);
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (node.getFirstChildOfType(ASTArrayDimsAndInits.class) != null) {
            return data;
        }
        ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)node.getFirstChildOfType(ASTClassOrInterfaceType.class);
        if (type == null) {
            return data;
        }
        if (TypeTestUtil.isA(Double.class, (TypeNode)type) || TypeTestUtil.isA(Float.class, (TypeNode)type) || TypeTestUtil.isA(Long.class, (TypeNode)type) || TypeTestUtil.isA(Integer.class, (TypeNode)type) || TypeTestUtil.isA(Short.class, (TypeNode)type) || TypeTestUtil.isA(Byte.class, (TypeNode)type) || TypeTestUtil.isA(Character.class, (TypeNode)type)) {
            this.addViolation(data, (Node)node, type.getImage());
        } else if (TypeTestUtil.isA(Boolean.class, (TypeNode)type)) {
            this.checkArguments((ASTArguments)node.getFirstChildOfType(ASTArguments.class), node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        if (!TypeTestUtil.isA(Boolean.class, (TypeNode)node)) {
            return data;
        }
        if (node.getNumChildren() >= 2 && ((JavaNode)node.getChild(0)).getNumChildren() > 0 && ((JavaNode)node.getChild(0)).getChild(0) instanceof ASTName && ((JavaNode)node.getChild(0)).getChild(0).hasImageEqualTo("Boolean.valueOf")) {
            ASTPrimarySuffix suffix = (ASTPrimarySuffix)node.getChild(1);
            this.checkArguments((ASTArguments)suffix.getFirstChildOfType(ASTArguments.class), node, data);
        }
        return data;
    }

    private void checkArguments(ASTArguments arguments, JavaNode node, Object data) {
        if (arguments == null || arguments.size() != 1) {
            return;
        }
        String messagePart = node instanceof ASTAllocationExpression ? "Do not use `new Boolean" : "Do not use `Boolean.valueOf";
        ASTLiteral stringLiteral = PrimitiveWrapperInstantiationRule.getFirstArgStringLiteralOrNull(arguments);
        ASTBooleanLiteral boolLiteral = PrimitiveWrapperInstantiationRule.getFirstArgBooleanLiteralOrNull(arguments);
        if (stringLiteral != null) {
            if (stringLiteral.hasImageEqualTo("\"true\"")) {
                this.addViolationWithMessage(data, (Node)node, messagePart + "(\"true\")`, prefer `Boolean.TRUE`");
            } else if (stringLiteral.hasImageEqualTo("\"false\"")) {
                this.addViolationWithMessage(data, (Node)node, messagePart + "(\"false\")`, prefer `Boolean.FALSE`");
            }
        } else if (boolLiteral != null) {
            if (boolLiteral.isTrue()) {
                this.addViolationWithMessage(data, (Node)node, messagePart + "(true)`, prefer `Boolean.TRUE`");
            } else {
                this.addViolationWithMessage(data, (Node)node, messagePart + "(false)`, prefer `Boolean.FALSE`");
            }
        }
    }

    private static ASTLiteral getFirstArgStringLiteralOrNull(ASTArguments arguments) {
        ASTExpression expr;
        ASTPrimaryExpression primaryExpr;
        ASTPrimaryPrefix prefix;
        ASTLiteral literal;
        if (arguments.size() == 1 && (literal = PrimitiveWrapperInstantiationRule.getSingleChildOf(prefix = PrimitiveWrapperInstantiationRule.getSingleChildOf(primaryExpr = PrimitiveWrapperInstantiationRule.getSingleChildOf(expr = (ASTExpression)arguments.getFirstDescendantOfType(ASTExpression.class), ASTPrimaryExpression.class), ASTPrimaryPrefix.class), ASTLiteral.class)) != null && literal.isStringLiteral()) {
            return literal;
        }
        return null;
    }

    private static ASTBooleanLiteral getFirstArgBooleanLiteralOrNull(ASTArguments arguments) {
        if (arguments.size() == 1) {
            ASTExpression expr = (ASTExpression)arguments.getFirstDescendantOfType(ASTExpression.class);
            ASTPrimaryExpression primaryExpr = PrimitiveWrapperInstantiationRule.getSingleChildOf(expr, ASTPrimaryExpression.class);
            ASTPrimaryPrefix prefix = PrimitiveWrapperInstantiationRule.getSingleChildOf(primaryExpr, ASTPrimaryPrefix.class);
            ASTLiteral literal = PrimitiveWrapperInstantiationRule.getSingleChildOf(prefix, ASTLiteral.class);
            return PrimitiveWrapperInstantiationRule.getSingleChildOf(literal, ASTBooleanLiteral.class);
        }
        return null;
    }

    private static <N extends JavaNode> N getSingleChildOf(JavaNode node, Class<N> type) {
        if (node == null || node.getNumChildren() != 1 || type != node.getChild(0).getClass()) {
            return null;
        }
        JavaNode result = node.getChild(0);
        return (N)result;
    }
}

