/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.multifile;

import java.util.Stack;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorReducedAdapter;
import net.sourceforge.pmd.lang.java.multifile.ClassStats;
import net.sourceforge.pmd.lang.java.multifile.PackageStats;

public class MultifileVisitor
extends JavaParserVisitorReducedAdapter {
    private final Stack<ClassStats> stack = new Stack();
    private final PackageStats toplevel;

    MultifileVisitor(PackageStats toplevel) {
        this.toplevel = toplevel;
    }

    @Override
    public Object visit(ASTAnyTypeDeclaration node, Object data) {
        this.stack.push(this.toplevel.getClassStats(node.getQualifiedName(), true));
        super.visit(node, data);
        this.stack.pop();
        return data;
    }

    @Override
    public Object visit(ASTMethodOrConstructorDeclaration node, Object data) {
        this.stack.peek().addOperation(node.getQualifiedName().getOperation(), node.getSignature());
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        this.stack.peek().addField(node.getVariableName(), node.getSignature());
        return data;
    }
}

