/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.common.iterable.LessStrings;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import com.google.common.annotations.VisibleForTesting;
import java.util.StringJoiner;

public enum ProfilingType {
    METHOD,
    SOQL,
    SOSL,
    DML,
    NONE;


    @VisibleForTesting
    static String getProfilingName(MethodCallExpression methodCall) {
        MethodInfo method = methodCall.getMethod().get();
        return method.getDefiningType().getBytecodeName().replace('/', '.') + "." + method.getName() + LessStrings.toString(methodCall.getInputParameters(), input -> input.getType().getApexName(), new StringJoiner(", ", "(", ")"));
    }

    public void emit(Emitter emitter, MethodCallExpression methodCall) {
        this.emit(emitter, methodCall.getLoc(), ProfilingType.getProfilingName(methodCall));
    }

    public void emit(Emitter emitter, Location loc, String descriptor) {
        if (this == NONE) {
            return;
        }
        emitter.push(loc, descriptor);
        emitter.push(loc, this.name());
        emitter.emit(loc, SystemEmitMethods.SET_PROFILING_INFO);
    }
}

