/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors.codeActions;

import apex.jorje.data.Location;
import apex.jorje.data.ast.ParameterRef;
import apex.jorje.data.ast.ParameterRefs;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.Range;

public class MissingMethodScope
extends Scope {
    private final ApexDocumentService docService;
    private final ApexCompilerService compilerService;
    private final int selectionStart;
    private final int selectionEnd;
    private final List<ParameterRef> parameterRefs;
    private final Map<String, Integer> parameterFrequencyTable;
    private Optional<MethodCallExpression> methodCallExpression;
    private Optional<UserClass> definingUserClass;
    private Document definingDocument;
    private Optional<TypeInfo> returnType;

    public MissingMethodScope(Document doc, Range range, ApexDocumentService docService, ApexCompilerService compilerService) throws BadLocationException {
        this.selectionStart = Locations.getOffset(doc, range.getStart());
        this.selectionEnd = Locations.getOffset(doc, range.getEnd());
        this.parameterFrequencyTable = new HashMap<String, Integer>();
        this.parameterRefs = new ArrayList<ParameterRef>();
        this.methodCallExpression = Optional.empty();
        this.definingUserClass = Optional.empty();
        this.returnType = Optional.empty();
        this.docService = docService;
        this.compilerService = compilerService;
    }

    public Optional<MethodCallExpression> getMethodCall() {
        return this.methodCallExpression;
    }

    void setMethodCall(final MethodCallExpression methodCallExpression) {
        this.methodCallExpression = Optional.ofNullable(methodCallExpression);
        URI refUri = URI.create(methodCallExpression.getReferenceType().getCodeUnitDetails().getSource().getKnownName());
        this.docService.retrieve(refUri).ifPresent(doc -> {
            this.definingDocument = doc;
            Compilation codeUnitNode = this.compilerService.compile((Document)doc).getNode();
            codeUnitNode.traverse(new AstVisitor<MissingMethodScope>(){

                @Override
                protected boolean defaultVisit() {
                    return true;
                }

                @Override
                public void visitEnd(UserClass node, MissingMethodScope scope) {
                    super.visitEnd(node, scope);
                    if (TypeInfoEquivalence.isEquivalent(node.getDefiningType(), methodCallExpression.getReferenceType())) {
                        MissingMethodScope.this.definingUserClass = Optional.of(node);
                    }
                }
            }, this);
        });
    }

    public Optional<TypeInfo> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(TypeInfo returnType) {
        this.returnType = Optional.of(returnType);
    }

    public Document getDefiningDocument() {
        return this.definingDocument;
    }

    public Optional<UserClass> getDefiningUserClass() {
        return this.definingUserClass;
    }

    void addPlaceholder(TypeRef typeRef, String name) {
        String placeholder = name;
        Integer count = this.parameterFrequencyTable.putIfAbsent(name.toLowerCase(), 0);
        if (count != null) {
            placeholder = placeholder + count;
        } else {
            count = 0;
        }
        this.parameterFrequencyTable.put(name, count + 1);
        this.parameterRefs.add(ParameterRefs.newParameterRef(typeRef, placeholder));
    }

    public List<ParameterRef> getParameterRefs() {
        return this.parameterRefs;
    }

    boolean isSelectionInNode(MethodCallExpression node) {
        if (node != null) {
            Location loc = node.getLoc();
            return this.selectionStart >= loc.getStartIndex() && this.selectionEnd <= loc.getEndIndex();
        }
        return false;
    }
}

