/*
 * Decompiled with CFR 0.152.
 */
package apex.common.collect;

import com.google.common.collect.BiMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class InternBiMap<L, R>
extends AbstractMap<L, R>
implements BiMap<L, R> {
    private final Map<L, WeakReference<R>> leftToRight = new WeakHashMap<L, WeakReference<R>>();
    private final Map<R, WeakReference<L>> rightToLeft = new WeakHashMap<R, WeakReference<L>>();
    private final Function<L, R> createRightFromLeft;
    private final Function<R, L> createLeftFromRight;
    private final Inverse inverse = new Inverse();

    private InternBiMap(Function<L, R> createRightFromLeft, Function<R, L> createLeftFromRight) {
        this.createRightFromLeft = createRightFromLeft;
        this.createLeftFromRight = createLeftFromRight;
    }

    public static <K, V> InternBiMap<K, V> create(Function<K, V> createRightFromLeft, Function<V, K> createLeftFromRight) {
        return new InternBiMap<K, V>(createRightFromLeft, createLeftFromRight);
    }

    private static <K, V> V get(Map<K, WeakReference<V>> map, K key, Function<K, V> supplier) {
        Object value;
        WeakReference<V> ref = map.get(key);
        if (ref != null && (value = ref.get()) != null) {
            return (V)value;
        }
        value = supplier.apply(key);
        map.put(key, new WeakReference(value));
        return (V)value;
    }

    private static <K, V> void put(Map<K, WeakReference<V>> map, K key, V value) {
        Object oldValue;
        WeakReference<V> ref = map.get(key);
        if (ref != null && (oldValue = ref.get()) != null) {
            return;
        }
        map.put(key, new WeakReference<V>(value));
    }

    @Override
    public int size() {
        assert (this.leftToRight.size() == this.rightToLeft.size()) : "size mismatch on bimap";
        return this.leftToRight.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R forcePut(L key, R value) {
        InternBiMap internBiMap = this;
        synchronized (internBiMap) {
            this.rightToLeft.put(value, new WeakReference<L>(key));
            return Optional.ofNullable(this.leftToRight.put(key, new WeakReference<R>(value))).map(Reference::get).orElse(null);
        }
    }

    public R computeValue(L key) {
        return this.createRightFromLeft.apply(key);
    }

    public L computeKey(R value) {
        return this.createLeftFromRight.apply(value);
    }

    @Override
    public boolean isEmpty() {
        assert (this.leftToRight.size() == this.rightToLeft.size()) : "size mismatch on bimap";
        return this.leftToRight.isEmpty();
    }

    @Override
    public Set<Map.Entry<L, R>> entrySet() {
        return this.leftToRight.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), ((WeakReference)entry.getValue()).get())).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get(Object obj) {
        InternBiMap internBiMap = this;
        synchronized (internBiMap) {
            Object key = obj;
            R value = InternBiMap.get(this.leftToRight, key, this.createRightFromLeft);
            InternBiMap.put(this.rightToLeft, value, key);
            return value;
        }
    }

    @Override
    public boolean containsKey(Object obj) {
        return this.leftToRight.containsKey(obj);
    }

    @Override
    public boolean containsValue(Object obj) {
        return this.inverse().containsKey(obj);
    }

    @Override
    public Set<R> values() {
        return this.rightToLeft.keySet();
    }

    @Override
    public BiMap<R, L> inverse() {
        return this.inverse;
    }

    private class Inverse
    extends AbstractMap<R, L>
    implements BiMap<R, L> {
        private Inverse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public L forcePut(R key, L value) {
            InternBiMap internBiMap = InternBiMap.this;
            synchronized (internBiMap) {
                InternBiMap.this.leftToRight.put(value, new WeakReference(key));
                return Optional.ofNullable(InternBiMap.this.rightToLeft.put(key, new WeakReference(value))).map(Reference::get).orElse(null);
            }
        }

        @Override
        public Set<L> values() {
            return InternBiMap.this.leftToRight.keySet();
        }

        @Override
        public BiMap<L, R> inverse() {
            return InternBiMap.this;
        }

        @Override
        public Set<Map.Entry<R, L>> entrySet() {
            return InternBiMap.this.rightToLeft.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), ((WeakReference)entry.getValue()).get())).collect(Collectors.toSet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public L get(Object obj) {
            InternBiMap internBiMap = InternBiMap.this;
            synchronized (internBiMap) {
                Object key = obj;
                Object value = InternBiMap.get(InternBiMap.this.rightToLeft, key, InternBiMap.this.createLeftFromRight);
                InternBiMap.put(InternBiMap.this.leftToRight, value, key);
                return value;
            }
        }

        @Override
        public boolean containsKey(Object obj) {
            return InternBiMap.this.rightToLeft.containsKey(obj);
        }

        @Override
        public boolean containsValue(Object obj) {
            return this.inverse().containsKey(obj);
        }

        @Override
        public boolean isEmpty() {
            return InternBiMap.this.isEmpty();
        }

        @Override
        public int size() {
            return InternBiMap.this.size();
        }
    }
}

