/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArgument;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class UnnecessaryCastRule
extends AbstractJavaRule {
    private static Set<String> implClassNames = new HashSet<String>();

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        this.process(node, data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        this.process(node, data);
        return super.visit(node, data);
    }

    private void process(Node node, Object data) {
        ASTClassOrInterfaceType collectionType = (ASTClassOrInterfaceType)node.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        if (collectionType == null || !implClassNames.contains(collectionType.getImage())) {
            return;
        }
        ASTClassOrInterfaceType cit = this.getCollectionItemType(collectionType);
        if (cit == null) {
            return;
        }
        ASTVariableDeclaratorId decl = (ASTVariableDeclaratorId)node.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
        List<NameOccurrence> usages = decl.getUsages();
        for (NameOccurrence no : usages) {
            ASTClassOrInterfaceType castTarget;
            ASTCastExpression castExpression = this.findCastExpression(no.getLocation());
            if (castExpression == null || (castTarget = (ASTClassOrInterfaceType)castExpression.getFirstDescendantOfType(ASTClassOrInterfaceType.class)) == null || !cit.getImage().equals(castTarget.getImage()) || castTarget.hasDescendantOfType(ASTTypeArgument.class)) continue;
            this.addViolation(data, (Node)castExpression);
        }
    }

    private ASTClassOrInterfaceType getCollectionItemType(ASTClassOrInterfaceType collectionType) {
        if (TypeTestUtil.isA(Map.class, (TypeNode)collectionType)) {
            List types = collectionType.findDescendantsOfType(ASTClassOrInterfaceType.class);
            if (types.size() >= 2) {
                return (ASTClassOrInterfaceType)types.get(1);
            }
        } else {
            return (ASTClassOrInterfaceType)collectionType.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        }
        return null;
    }

    private ASTCastExpression findCastExpression(ScopedNode usage) {
        Node n = usage.getNthParent(2);
        if (n instanceof ASTCastExpression) {
            return (ASTCastExpression)n;
        }
        if ((n = n.getParent()) instanceof ASTCastExpression) {
            return (ASTCastExpression)n;
        }
        return null;
    }

    static {
        implClassNames.add("List");
        implClassNames.add("Set");
        implClassNames.add("Map");
        implClassNames.add("java.util.List");
        implClassNames.add("java.util.Set");
        implClassNames.add("java.util.Map");
        implClassNames.add("ArrayList");
        implClassNames.add("HashSet");
        implClassNames.add("HashMap");
        implClassNames.add("LinkedHashMap");
        implClassNames.add("LinkedHashSet");
        implClassNames.add("TreeSet");
        implClassNames.add("TreeMap");
        implClassNames.add("Vector");
        implClassNames.add("java.util.ArrayList");
        implClassNames.add("java.util.HashSet");
        implClassNames.add("java.util.HashMap");
        implClassNames.add("java.util.LinkedHashMap");
        implClassNames.add("java.util.LinkedHashSet");
        implClassNames.add("java.util.TreeSet");
        implClassNames.add("java.util.TreeMap");
        implClassNames.add("java.util.Vector");
        implClassNames.add("Iterator");
        implClassNames.add("java.util.Iterator");
    }
}

