/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;

public class IDEAJRenderer
extends AbstractIncrementingRenderer {
    private String classAndMethodName;
    private String fileName;
    public static final String NAME = "ideaj";
    public static final StringProperty FILE_NAME = new StringProperty("fileName", "File name.", "", 0.0f);
    public static final StringProperty SOURCE_PATH = new StringProperty("sourcePath", "Source path.", "", 1.0f);
    public static final StringProperty CLASS_AND_METHOD_NAME = new StringProperty("classAndMethodName", "Class and Method name, pass '.method' when processing a directory.", "", 2.0f);
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");

    public IDEAJRenderer() {
        super(NAME, "IntelliJ IDEA integration.");
        this.definePropertyDescriptor(FILE_NAME);
        this.definePropertyDescriptor(SOURCE_PATH);
        this.definePropertyDescriptor(CLASS_AND_METHOD_NAME);
    }

    @Override
    public String defaultFileExtension() {
        return "txt";
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        this.classAndMethodName = this.getProperty(CLASS_AND_METHOD_NAME);
        this.fileName = this.getProperty(FILE_NAME);
        if (".method".equals(this.classAndMethodName)) {
            this.renderDirectory(this.writer, violations);
        } else {
            this.renderFile(this.writer, violations);
        }
    }

    private void renderDirectory(Writer writer, Iterator<RuleViolation> violations) throws IOException {
        SourcePath sourcePath = new SourcePath(this.getProperty(SOURCE_PATH));
        StringBuilder buf = new StringBuilder();
        while (violations.hasNext()) {
            buf.setLength(0);
            RuleViolation rv = violations.next();
            buf.append(rv.getDescription()).append(PMD.EOL);
            buf.append(" at ").append(this.getFullyQualifiedClassName(rv.getFilename(), sourcePath)).append(".method(");
            buf.append(this.getSimpleFileName(rv.getFilename())).append(':').append(rv.getBeginLine()).append(')').append(PMD.EOL);
            writer.write(buf.toString());
        }
    }

    private void renderFile(Writer writer, Iterator<RuleViolation> violations) throws IOException {
        StringBuilder buf = new StringBuilder();
        while (violations.hasNext()) {
            buf.setLength(0);
            RuleViolation rv = violations.next();
            buf.append(rv.getDescription()).append(PMD.EOL);
            buf.append(" at ").append(this.classAndMethodName).append('(').append(this.fileName).append(':').append(rv.getBeginLine()).append(')').append(PMD.EOL);
            writer.write(buf.toString());
        }
    }

    private String getFullyQualifiedClassName(String fileName, SourcePath sourcePath) {
        String classNameWithSlashes = sourcePath.clipPath(fileName);
        String className = classNameWithSlashes.replace(FILE_SEPARATOR.charAt(0), '.');
        return className.substring(0, className.length() - 5);
    }

    private String getSimpleFileName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(FILE_SEPARATOR) + 1);
    }

    private static class SourcePath {
        private Set<String> paths = new HashSet<String>();

        SourcePath(String sourcePathString) {
            StringTokenizer st = new StringTokenizer(sourcePathString, PATH_SEPARATOR);
            while (st.hasMoreTokens()) {
                this.paths.add(st.nextToken());
            }
        }

        public String clipPath(String fullFilename) {
            for (String path : this.paths) {
                if (!fullFilename.startsWith(path)) continue;
                return fullFilename.substring(path.length() + 1);
            }
            throw new RuntimeException("Couldn't find src path for " + fullFilename);
        }
    }
}

