/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetLoader;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RulesetsFactoryUtils;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.benchmark.TextTimingReportRenderer;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.benchmark.TimingReport;
import net.sourceforge.pmd.cache.NoopAnalysisCache;
import net.sourceforge.pmd.cli.PMDCommandLineInterface;
import net.sourceforge.pmd.cli.PMDParameters;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageFilenameFilter;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ParserOptions;
import net.sourceforge.pmd.processor.AbstractPMDProcessor;
import net.sourceforge.pmd.processor.MonoThreadProcessor;
import net.sourceforge.pmd.processor.MultiThreadProcessor;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.ClasspathClassLoader;
import net.sourceforge.pmd.util.FileUtil;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.database.DBMSMetadata;
import net.sourceforge.pmd.util.database.DBURI;
import net.sourceforge.pmd.util.database.SourceObject;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.ReaderDataSource;
import net.sourceforge.pmd.util.log.ScopedLogHandlersManager;

public class PMD {
    private static final Logger LOG = Logger.getLogger(PMD.class.getName());
    public static final String EOL = System.getProperty("line.separator", "\n");
    public static final String SUPPRESS_MARKER = "NOPMD";
    protected final PMDConfiguration configuration;
    private final SourceCodeProcessor rulesetsFileProcessor;
    @Deprecated
    public static final String VERSION = PMDVersion.VERSION;

    @Deprecated
    public PMD() {
        this(new PMDConfiguration());
    }

    @Deprecated
    public PMD(PMDConfiguration configuration) {
        this.configuration = configuration;
        this.rulesetsFileProcessor = new SourceCodeProcessor(configuration);
    }

    @Deprecated
    public static List<DataSource> getURIDataSources(String uriString) throws PMDException {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        try {
            DBURI dbUri = new DBURI(uriString);
            DBMSMetadata dbmsMetadata = new DBMSMetadata(dbUri);
            LOG.log(Level.FINE, "DBMSMetadata retrieved");
            List<SourceObject> sourceObjectList = dbmsMetadata.getSourceObjectList();
            LOG.log(Level.FINE, "Located {0} database source objects", sourceObjectList.size());
            for (SourceObject sourceObject : sourceObjectList) {
                String falseFilePath = sourceObject.getPseudoFileName();
                LOG.log(Level.FINEST, "Adding database source object {0}", falseFilePath);
                try {
                    dataSources.add(new ReaderDataSource(dbmsMetadata.getSourceCode(sourceObject), falseFilePath));
                }
                catch (SQLException ex) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Cannot get SourceCode for " + falseFilePath + "  - skipping ...", ex);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new PMDException("Cannot get DataSources from DBURI - \"" + uriString + "\"", e);
        }
        catch (SQLException e) {
            throw new PMDException("Cannot get DataSources from DBURI, couldn't access the database - \"" + uriString + "\"", e);
        }
        catch (ClassNotFoundException e) {
            throw new PMDException("Cannot get DataSources from DBURI, probably missing database jdbc driver - \"" + uriString + "\"", e);
        }
        catch (Exception e) {
            throw new PMDException("Encountered unexpected problem with URI \"" + uriString + "\"", e);
        }
        return dataSources;
    }

    @Deprecated
    @InternalApi
    public static Parser parserFor(LanguageVersion languageVersion, PMDConfiguration configuration) {
        LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
        ParserOptions options = languageVersionHandler.getDefaultParserOptions();
        if (configuration != null) {
            options.setSuppressMarker(configuration.getSuppressMarker());
        }
        return languageVersionHandler.getParser(options);
    }

    @Deprecated
    public PMDConfiguration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public SourceCodeProcessor getSourceCodeProcessor() {
        return this.rulesetsFileProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doPMD(PMDConfiguration configuration) {
        RuleSetFactory ruleSetFactory = RuleSetLoader.fromPmdConfig(configuration).toFactory();
        RuleSets ruleSets = RulesetsFactoryUtils.getRuleSetsWithBenchmark(configuration.getRuleSets(), ruleSetFactory);
        if (ruleSets == null) {
            return 0;
        }
        List<DataSource> files = PMD.getApplicableFiles(configuration, PMD.getApplicableLanguages(configuration, ruleSets));
        try {
            Report report;
            List<Renderer> renderers;
            Renderer renderer;
            try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.REPORTING);){
                renderer = configuration.createRenderer();
                renderers = Collections.singletonList(renderer);
                renderer.setReportFile(configuration.getReportFile());
                renderer.start();
            }
            try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.FILE_PROCESSING);){
                report = PMD.processFiles(configuration, Arrays.asList(ruleSets.getAllRuleSets()), files, renderers);
            }
            TimedOperation rto = TimeTracker.startOperation(TimedOperationCategory.REPORTING);
            try {
                renderer.end();
                renderer.flush();
                int n = report.getViolations().size();
                if (rto != null) {
                    rto.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                try {
                    if (rto != null) {
                        try {
                            rto.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message != null) {
                        LOG.severe(message);
                    } else {
                        LOG.log(Level.SEVERE, "Exception during processing", e);
                    }
                    LOG.log(Level.FINE, "Exception during processing", e);
                    LOG.info(PMDCommandLineInterface.buildUsageText());
                    int n = 0;
                    return n;
                }
            }
        }
        finally {
            if (configuration.getClassLoader() instanceof ClasspathClassLoader) {
                IOUtil.tryCloseClassLoader(configuration.getClassLoader());
            }
        }
    }

    @Deprecated
    public static RuleContext newRuleContext(String sourceCodeFilename, File sourceCodeFile) {
        RuleContext context = new RuleContext();
        context.setSourceCodeFile(sourceCodeFile);
        context.setReport(new Report());
        return context;
    }

    @Deprecated
    public static void processFiles(PMDConfiguration configuration, RuleSetFactory ruleSetFactory, List<DataSource> files, RuleContext ctx, List<Renderer> renderers) {
        PMD.encourageToUseIncrementalAnalysis(configuration);
        PMD.sortFiles(configuration, files);
        ctx.getReport().addListener(configuration.getAnalysisCache());
        RuleSetFactory silentFactory = ruleSetFactory.toLoader().warnDeprecated(false).toFactory();
        PMD.newFileProcessor(configuration).processFiles(silentFactory, files, ctx, renderers);
        configuration.getAnalysisCache().persist();
    }

    public static Report processFiles(PMDConfiguration configuration, List<RuleSet> rulesets, Collection<? extends DataSource> files, List<Renderer> renderers) {
        PMD.encourageToUseIncrementalAnalysis(configuration);
        Report report = new Report();
        report.addListener(configuration.getAnalysisCache());
        ArrayList<DataSource> sortedFiles = new ArrayList<DataSource>(files);
        PMD.sortFiles(configuration, sortedFiles);
        RuleContext ctx = new RuleContext();
        ctx.setReport(report);
        PMD.newFileProcessor(configuration).processFiles(new RuleSets(rulesets), sortedFiles, ctx, renderers);
        configuration.getAnalysisCache().persist();
        return report;
    }

    private static void sortFiles(PMDConfiguration configuration, List<DataSource> files) {
        if (configuration.isStressTest()) {
            Collections.shuffle(files);
        } else {
            final boolean useShortNames = configuration.isReportShortNames();
            final String inputPaths = configuration.getInputPaths();
            Collections.sort(files, new Comparator<DataSource>(){

                @Override
                public int compare(DataSource left, DataSource right) {
                    String leftString = left.getNiceFileName(useShortNames, inputPaths);
                    String rightString = right.getNiceFileName(useShortNames, inputPaths);
                    return leftString.compareTo(rightString);
                }
            });
        }
    }

    private static void encourageToUseIncrementalAnalysis(PMDConfiguration configuration) {
        if (!configuration.isIgnoreIncrementalAnalysis() && configuration.getAnalysisCache() instanceof NoopAnalysisCache && LOG.isLoggable(Level.WARNING)) {
            String version = PMDVersion.isUnknown() || PMDVersion.isSnapshot() ? "latest" : "pmd-" + PMDVersion.VERSION;
            LOG.warning("This analysis could be faster, please consider using Incremental Analysis: https://pmd.github.io/" + version + "/pmd_userdocs_incremental_analysis.html");
        }
    }

    private static AbstractPMDProcessor newFileProcessor(PMDConfiguration configuration) {
        return configuration.getThreads() > 0 ? new MultiThreadProcessor(configuration) : new MonoThreadProcessor(configuration);
    }

    public static List<DataSource> getApplicableFiles(PMDConfiguration configuration, Set<Language> languages) {
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.COLLECT_FILES);){
            List<DataSource> list = PMD.internalGetApplicableFiles(configuration, languages);
            return list;
        }
    }

    private static List<DataSource> internalGetApplicableFiles(PMDConfiguration configuration, Set<Language> languages) {
        String filePaths;
        File file;
        LanguageFilenameFilter fileSelector = new LanguageFilenameFilter(languages);
        ArrayList<DataSource> files = new ArrayList<DataSource>();
        if (null != configuration.getInputPaths()) {
            files.addAll(FileUtil.collectFiles(configuration.getInputPaths(), fileSelector));
        }
        if (null != configuration.getInputUri()) {
            String uriString = configuration.getInputUri();
            try {
                List<DataSource> dataSources = PMD.getURIDataSources(uriString);
                files.addAll(dataSources);
            }
            catch (PMDException ex) {
                LOG.log(Level.SEVERE, "Problem with Input URI", ex);
                throw new RuntimeException("Problem with DBURI: " + uriString, ex);
            }
        }
        if (null != configuration.getInputFilePath()) {
            String inputFilePath = configuration.getInputFilePath();
            file = new File(inputFilePath);
            try {
                if (!file.exists()) {
                    LOG.log(Level.SEVERE, "Problem with Input File Path", inputFilePath);
                    throw new RuntimeException("Problem with Input File Path: " + inputFilePath);
                }
                filePaths = FileUtil.readFilelist(new File(inputFilePath));
                files.addAll(FileUtil.collectFiles(filePaths, fileSelector));
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Problem with Input File", ex);
                throw new RuntimeException("Problem with Input File Path: " + inputFilePath, ex);
            }
        }
        if (null != configuration.getIgnoreFilePath()) {
            String ignoreFilePath = configuration.getIgnoreFilePath();
            file = new File(ignoreFilePath);
            try {
                if (!file.exists()) {
                    LOG.log(Level.SEVERE, "Problem with Ignore File Path", ignoreFilePath);
                    throw new RuntimeException("Problem with Ignore File Path: " + ignoreFilePath);
                }
                filePaths = FileUtil.readFilelist(new File(ignoreFilePath));
                files.removeAll(FileUtil.collectFiles(filePaths, fileSelector));
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Problem with Ignore File", ex);
                throw new RuntimeException("Problem with Ignore File Path: " + ignoreFilePath, ex);
            }
        }
        return files;
    }

    private static Set<Language> getApplicableLanguages(PMDConfiguration configuration, RuleSets ruleSets) {
        HashSet<Language> languages = new HashSet<Language>();
        LanguageVersionDiscoverer discoverer = configuration.getLanguageVersionDiscoverer();
        for (Rule rule : ruleSets.getAllRules()) {
            LanguageVersion version;
            Language ruleLanguage = rule.getLanguage();
            if (languages.contains(ruleLanguage) || !RuleSet.applies(rule, version = discoverer.getDefaultLanguageVersion(ruleLanguage))) continue;
            languages.add(ruleLanguage);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Using " + ruleLanguage.getShortName() + " version: " + version.getShortName());
        }
        return languages;
    }

    public static void main(String[] args) {
        PMDCommandLineInterface.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(String[] args) {
        PMDParameters params = PMDCommandLineInterface.extractParameters(new PMDParameters(), args, "pmd");
        if (params.isBenchmark()) {
            TimeTracker.startGlobalTracking();
        }
        int status = 0;
        PMDConfiguration configuration = params.toConfiguration();
        Level logLevel = params.isDebug() ? Level.FINER : Level.INFO;
        ScopedLogHandlersManager logHandlerManager = new ScopedLogHandlersManager(logLevel, new ConsoleHandler());
        Level oldLogLevel = LOG.getLevel();
        LOG.setLevel(logLevel);
        try {
            int violations = PMD.doPMD(configuration);
            status = violations > 0 && configuration.isFailOnViolation() ? 4 : 0;
        }
        catch (Exception e) {
            System.out.println(PMDCommandLineInterface.buildUsageText());
            System.out.println();
            System.err.println(e.getMessage());
            status = 1;
        }
        finally {
            logHandlerManager.close();
            LOG.setLevel(oldLogLevel);
            if (params.isBenchmark()) {
                TimingReport timingReport = TimeTracker.stopGlobalTracking();
                TextTimingReportRenderer renderer = new TextTimingReportRenderer();
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(System.err);
                    renderer.render(timingReport, writer);
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        return status;
    }
}

