/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractIgnoredAnnotationRule;

public class AtLeastOneConstructorRule
extends AbstractIgnoredAnnotationRule {
    public AtLeastOneConstructorRule() {
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
    }

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return Arrays.asList("lombok.Data", "lombok.Value", "lombok.Builder", "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor");
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface() || node.isStatic() || node.hasDescendantOfType(ASTConstructorDeclaration.class) || this.hasIgnoredAnnotation(node)) {
            return data;
        }
        boolean atLeastOneMember = false;
        for (ASTMethodDeclaration m : node.findDescendantsOfType(ASTMethodDeclaration.class)) {
            if (!m.isStatic()) {
                this.addViolation(data, node);
                return data;
            }
            atLeastOneMember = true;
        }
        for (ASTFieldDeclaration f : node.findDescendantsOfType(ASTFieldDeclaration.class)) {
            if (!f.isStatic()) {
                this.addViolation(data, node);
                return data;
            }
            atLeastOneMember = true;
        }
        if (!atLeastOneMember) {
            this.addViolation(data, node);
        }
        return data;
    }
}

