/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.common.collect.MoreIterables;
import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.ClassRefExpression;
import apex.jorje.semantic.ast.expression.EmptyReferenceExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.DmlDeleteStatement;
import apex.jorje.semantic.ast.statement.DmlInsertStatement;
import apex.jorje.semantic.ast.statement.DmlMergeStatement;
import apex.jorje.semantic.ast.statement.DmlUndeleteStatement;
import apex.jorje.semantic.ast.statement.DmlUpdateStatement;
import apex.jorje.semantic.ast.statement.DmlUpsertStatement;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.ast.visitor.reference.ReferenceInfo;
import apex.jorje.semantic.ast.visitor.reference.ReferencedTypeVisitor;
import apex.jorje.semantic.ast.visitor.reference.SObjectReferenceUtil;
import apex.jorje.semantic.ast.visitor.reference.VariableReferenceUtil;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableUtil;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameFactory;
import apex.jorje.semantic.symbol.type.reference.TypeReferences;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;

public class ReferenceVisitor
extends AstVisitor<SymbolScope> {
    private static final AstVisitor<ValueScope<ReferenceInfo>> GET_UPSERT_REFERENCE = new AstVisitor<ValueScope<ReferenceInfo>>(){

        @Override
        public void visitEnd(VariableExpression node, ValueScope<ReferenceInfo> scope) {
            ReferenceInfo reference = VariableUtil.isUpsertField(node.getVariable()) ? ReferenceInfo.builder().setVariable(node.getVariable()).setDmlOperation(DmlOperation.UPSERT).build() : ReferenceInfo.UPSERT;
            scope.setValue(reference);
        }
    };
    private final List<ExternalDependency> references;
    private final TypeInfo referencingType;
    private final SymbolResolver symbols;

    public ReferenceVisitor(TypeInfo referencingType, SymbolResolver symbols) {
        assert (TypeInfoUtil.isTopLevel(referencingType)) : "Reference visitors can only be created for top level types";
        this.referencingType = referencingType;
        this.symbols = symbols;
        this.references = new ArrayList<ExternalDependency>();
    }

    public TypeInfo getReferencingType() {
        return this.referencingType;
    }

    public List<ExternalDependency> getReferences() {
        return this.references;
    }

    @Override
    public boolean defaultVisit() {
        return true;
    }

    @Override
    public boolean visit(UserClass node, SymbolScope scope) {
        TypeInfo superType = node.getDefiningType().parents().superType();
        Optional<TypeRef> superTypeRef = node.getDefiningType().getCodeUnitDetails().getSuperTypeRef();
        superTypeRef.ifPresent(typeRef -> this.checkAndAddReferenceRelationshipWithoutField(superType, (TypeRef)typeRef, node.getLoc()));
        List<TypeRef> interfaceRefs = node.getDefiningType().getCodeUnitDetails().getInterfaceTypeRefs();
        int index = 0;
        for (TypeInfo interfaceType : node.getDefiningType().parents().immediateInterfaces()) {
            this.checkAndAddReferenceRelationshipWithoutField(interfaceType, interfaceRefs.get(index), node.getLoc());
            ++index;
        }
        return true;
    }

    @Override
    public boolean visit(UserInterface node, SymbolScope scope) {
        List<TypeInfo> superTypes = node.getDefiningType().parents().immediateInterfaces();
        List<TypeRef> superTypeRefs = node.getDefiningType().getCodeUnitDetails().getInterfaceTypeRefs();
        assert (superTypeRefs.size() == superTypes.size()) : "interface type ref to type mismatch";
        if (!superTypeRefs.isEmpty()) {
            TypeInfo superType = MoreIterables.getOnlyElement(superTypes);
            assert (superTypeRefs.size() == 1) : "an interface can only extend a single interface";
            this.checkAndAddReferenceRelationshipWithoutField(superType, superTypeRefs.get(0), node.getLoc());
        }
        return true;
    }

    @Override
    public boolean visit(UserTrigger node, SymbolScope scope) {
        TypeInfo sobjectTypeInfo = node.getTargetType();
        this.checkAndAddReferenceRelationship(sobjectTypeInfo, node.getLoc(), Optional.ofNullable(node.getSObjectTypeRef()), ReferenceInfo.empty(), ReferencedFromTriggerDecl.YES);
        return true;
    }

    @Override
    public boolean visit(ClassRefExpression node, SymbolScope scope) {
        if (node.getVariable().isPresent()) {
            Variable variable = node.getVariable().get();
            this.checkAndAddVariableRelationship(variable.getDefiningType(), variable.getLoc(), ReferenceInfo.builder().setVariable(variable).setReferencedViaForeignKey(false).build());
        } else {
            this.checkAndAddReferenceRelationshipWithoutField(node.getClassType(), node.getTypeRef(), node.getLoc());
        }
        return true;
    }

    @Override
    public boolean visit(CastExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getCastType(), node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(InstanceOfExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getInstanceOfType(), node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(ReferenceExpression node, SymbolScope scope) {
        boolean isMethodCall = node.getReferenceType() == ReferenceType.METHOD;
        SObjectReferenceUtil.get().addSObjectTypeIfStaticReference(node, this);
        if (isMethodCall && node.getSpecialStatic() != null) {
            VariableReferenceUtil.get().variableVisit(this, node.getSpecialStatic(), node, ReferenceType.LOAD, false, true);
            return true;
        }
        Optional<Variable> previous = Optional.empty();
        int variableCounter = 1;
        for (Variable fieldInfo : node.getVariables()) {
            VariableReferenceUtil.get().variableVisit(this, fieldInfo, node, ReferenceType.LOAD, previous.map(VariableUtil::isForeignKey).orElse(false), isMethodCall && variableCounter == node.getVariables().size());
            ++variableCounter;
            previous = Optional.of(fieldInfo);
        }
        return true;
    }

    @Override
    public boolean visit(MethodCallExpression node, SymbolScope scope) {
        MethodInfo methodInfo = node.getMethod().get();
        TypeInfo definingType = methodInfo.getDefiningType();
        this.validateDatabaseMethods(methodInfo, node.getInputParameters(), node.getLoc());
        if (!(!methodInfo.getModifiers().has(ModifierTypeInfos.STATIC) || SObjectTypeInfoUtil.isConcreteSObject(methodInfo.getDefiningType()) || EmptyReferenceExpression.isEmptyReference(node.getReferenceContext()) && TypeInfoUtil.isAncestor(this.referencingType, definingType))) {
            this.checkAndAddReferenceRelationshipWithoutField(definingType, node.getLoc());
        }
        return true;
    }

    @Override
    public boolean visit(NewListInitExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getType(), node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(NewMapInitExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getType(), node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(NewSetInitExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getType(), node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(NewListLiteralExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getType(), node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(NewSetLiteralExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getType(), node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(NewMapLiteralExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getType(), node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(NewObjectExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getType(), node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(NewKeyValueObjectExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithoutField(node.getType(), node.getTypeRef(), node.getLoc());
        for (NewKeyValueObjectExpression.NameValueParameter parameter : node.getParameters()) {
            SObjectFieldInfo info = parameter.getSObjectField();
            if (info == null) continue;
            DmlOperation dmlOperation = this.isEditable(info, !info.isPrimaryKey());
            this.checkAndAddReferenceRelationshipWithField(info.getDefiningType(), node.getLoc(), ReferenceInfo.builder().setVariable(info).setLast(true).setDmlOperation(dmlOperation).build());
        }
        return true;
    }

    @Override
    public boolean visit(VariableExpression node, SymbolScope scope) {
        boolean isReferencedViaForeignKey = Optional.ofNullable(Iterables.getLast(node.getReferenceContext().getVariables(), null)).map(VariableUtil::isForeignKey).orElse(false);
        VariableReferenceUtil.get().variableVisit(this, node.getVariable(), node.getReferenceContext(), node.getReferenceType(), isReferencedViaForeignKey, true);
        return true;
    }

    DmlOperation isEditable(Variable variable, boolean condition) {
        return condition && VariableUtil.canBeEditable(variable) ? DmlOperation.EDIT : null;
    }

    private void validateDatabaseMethods(MethodInfo methodInfo, List<Expression> inputParameters, Location loc) {
        ReferenceInfo referenceInfo;
        switch (methodInfo.getDmlOperation()) {
            case DELETE: {
                referenceInfo = ReferenceInfo.DELETE;
                break;
            }
            case INSERT: {
                referenceInfo = ReferenceInfo.INSERT;
                break;
            }
            case MERGE: {
                referenceInfo = ReferenceInfo.MERGE;
                break;
            }
            case UNDELETE: {
                referenceInfo = ReferenceInfo.UNDELETE;
                break;
            }
            case UPDATE: {
                referenceInfo = ReferenceInfo.UPDATE;
                break;
            }
            case UPSERT: {
                referenceInfo = this.getUpsertReference(inputParameters);
                break;
            }
            case EDIT: {
                return;
            }
            case LEAD_CONVERT: {
                return;
            }
            case NONE: {
                return;
            }
            default: {
                return;
            }
        }
        if (inputParameters.isEmpty()) {
            assert (false) : "asking to track dml operation reference for method without parameters";
            return;
        }
        TypeInfo paramType = TypeInfoUtil.peelType(inputParameters.get(0).getType());
        this.checkAndAddReferenceRelationshipWithField(paramType, loc, referenceInfo);
    }

    private ReferenceInfo getUpsertReference(List<Expression> inputParameters) {
        return inputParameters.size() > 1 ? ValueScope.evaluate(inputParameters.get(1), GET_UPSERT_REFERENCE, ReferenceInfo.UPSERT) : ReferenceInfo.UPSERT;
    }

    private boolean isMyCodeUnit(TypeInfo referredType) {
        return TypeInfoEquivalence.isEquivalent(TypeInfoUtil.getTopLevel(referredType), this.referencingType) && TypeInfoUtil.getTopLevel(referredType).getUnitType() == this.referencingType.getUnitType();
    }

    private void checkAndAddReferenceRelationshipWithoutField(TypeInfo referredType, TypeRef referredTypeRef, Location loc) {
        this.checkAndAddReferenceRelationship(referredType, loc, Optional.ofNullable(referredTypeRef), ReferenceInfo.empty(), ReferencedFromTriggerDecl.NO);
    }

    private void checkAndAddReferenceRelationshipWithoutField(TypeInfo referredType, Location loc) {
        this.checkAndAddReferenceRelationship(referredType, loc, Optional.empty(), ReferenceInfo.empty(), ReferencedFromTriggerDecl.NO);
    }

    private void checkAndAddReferenceRelationshipWithField(TypeInfo referredType, Location loc, ReferenceInfo info) {
        this.checkAndAddReferenceRelationship(referredType, loc, Optional.empty(), info, ReferencedFromTriggerDecl.NO);
    }

    private void checkAndAddReferenceRelationship(TypeInfo referredType, Location loc, Optional<TypeRef> typeRefOptional, ReferenceInfo referenceInfo, ReferencedFromTriggerDecl referencedFromTriggerDecl) {
        if (typeRefOptional.isPresent() && typeRefOptional.get() != TypeReferences.GENERATED_TYPE_REF) {
            this.addReferencesWalkingTypeRef(referredType, typeRefOptional.get(), loc, referenceInfo, referencedFromTriggerDecl);
        } else {
            this.addReferenceWalkingTypeArguments(referredType, loc, referenceInfo);
        }
    }

    void checkAndAddVariableRelationship(TypeInfo referredType, Location loc, ReferenceInfo referenceInfo) {
        this.checkAndAddReferenceRelationship(referredType, loc, Optional.empty(), referenceInfo, ReferencedFromTriggerDecl.NO);
    }

    @VisibleForTesting
    void addReferencesWalkingTypeRef(TypeInfo referredType, TypeRef someTypeRef, Location loc, ReferenceInfo referenceInfo, ReferencedFromTriggerDecl referencedFromTriggerDecl) {
        TypeInfo rootType = GenericTypeInfoUtil.getRootType(referredType);
        if (SObjectTypeInfoUtil.isConcreteSObject(rootType)) {
            if (referencedFromTriggerDecl == ReferencedFromTriggerDecl.YES || !Namespaces.SCHEMA.getNameLower().equalsIgnoreCase(someTypeRef.getNames().get(0).getValue())) {
                this.addReferenceToList(rootType, loc, referenceInfo);
            }
        } else if (TypeInfoUtil.isInnerType(referredType)) {
            if (TypeNameFactory.isFullyQualified(someTypeRef.getNames().size(), this.referencingType, referredType)) {
                List<Identifier> allNamesMinusLast = MoreLists.removeLast(someTypeRef.getNames());
                TypeInfo enclosingType = this.symbols.lookupTypeInfoIdentifiers(this.referencingType, allNamesMinusLast, ReferenceType.NONE);
                TypeInfo typeToReference = enclosingType.isResolved() && TypeInfoUtil.isTopLevel(enclosingType) && enclosingType != referredType.getEnclosingType() ? enclosingType : rootType;
                this.addReferenceToList(typeToReference, loc, referenceInfo);
            }
        } else {
            this.addReferenceToList(rootType, loc, referenceInfo);
        }
        if (!GenericTypeInfoUtil.isGenericType(referredType) && !someTypeRef.getTypeArguments().isEmpty()) {
            return;
        }
        assert (referredType.getTypeArguments().size() == someTypeRef.getTypeArguments().size()) : "type ref size mismatch with type argument size should match";
        for (int i = 0; i < referredType.getTypeArguments().size(); ++i) {
            this.addReferencesWalkingTypeRef(referredType.getTypeArguments().get(i), someTypeRef.getTypeArguments().get(i), loc, referenceInfo, ReferencedFromTriggerDecl.NO);
        }
    }

    void addReferenceWalkingTypeArguments(TypeInfo referredType, Location loc, ReferenceInfo referenceInfo) {
        TypeInfo rootType = GenericTypeInfoUtil.getRootType(referredType);
        this.addReferenceToList(rootType, loc, referenceInfo);
        for (TypeInfo argumentType : referredType.getTypeArguments()) {
            this.addReferenceWalkingTypeArguments(argumentType, loc, referenceInfo);
        }
    }

    private void addReferenceToList(TypeInfo referredType, Location loc, ReferenceInfo referenceInfo) {
        if (!this.isMyCodeUnit(referredType) && referredType.accept(ReferencedTypeVisitor.get()).booleanValue()) {
            this.references.add(ExternalDependency.create(referredType, loc, referenceInfo));
        }
    }

    public Set<TypeInfo> calculateReferencesForErrorPropagation() {
        WeakHashMap weakMap = new WeakHashMap();
        Set<TypeInfo> set = Collections.newSetFromMap(weakMap);
        for (ExternalDependency externalDependency : this.references) {
            set.add(TypeInfoUtil.getTopLevel(externalDependency.getTypeInfo()));
        }
        return set;
    }

    SymbolResolver getSymbols() {
        return this.symbols;
    }

    @Override
    public boolean visit(DmlDeleteStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithField(node.getExpression().getType(), node.getLoc(), ReferenceInfo.DELETE);
        return true;
    }

    @Override
    public boolean visit(DmlInsertStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithField(node.getExpression().getType(), node.getLoc(), ReferenceInfo.INSERT);
        return true;
    }

    @Override
    public boolean visit(DmlMergeStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithField(node.getExpression().getType(), node.getLoc(), ReferenceInfo.MERGE);
        return true;
    }

    @Override
    public boolean visit(DmlUndeleteStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithField(node.getExpression().getType(), node.getLoc(), ReferenceInfo.UNDELETE);
        return true;
    }

    @Override
    public boolean visit(DmlUpdateStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationshipWithField(node.getExpression().getType(), node.getLoc(), ReferenceInfo.UPDATE);
        return true;
    }

    @Override
    public boolean visit(DmlUpsertStatement node, SymbolScope scope) {
        ReferenceInfo referenceInfo;
        TypeInfo entityType = node.getExpression().getType();
        if (node.getFieldIdentifier().isPresent()) {
            Object fieldInfo = ((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)SObjectFieldInfo.builder().setDefiningType(entityType)).setType(InternalTypeInfos.SCHEMA_SOBJECT_FIELD)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).setName(node.getFieldIdentifier().get().field.getValue())).build();
            referenceInfo = ReferenceInfo.builder().setVariable((Variable)fieldInfo).setDmlOperation(DmlOperation.UPSERT).build();
        } else {
            referenceInfo = ReferenceInfo.UPSERT;
        }
        this.checkAndAddReferenceRelationshipWithField(node.getExpression().getType(), node.getLoc(), referenceInfo);
        return true;
    }

    @Override
    public boolean visit(VariableDeclaration node, SymbolScope scope) {
        TypeInfo varType = node.getLocalInfo().getType();
        this.checkAndAddReferenceRelationshipWithoutField(varType, node.getTypeNameUsed(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(CatchBlockStatement node, SymbolScope scope) {
        TypeInfo varType = node.getVariable().getType();
        this.checkAndAddReferenceRelationshipWithoutField(varType, node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(Field node, SymbolScope scope) {
        TypeInfo fieldType = node.getFieldInfo().getType();
        this.checkAndAddReferenceRelationshipWithoutField(fieldType, node.getTypeRef(), node.getLoc());
        return true;
    }

    @Override
    public boolean visit(Method node, SymbolScope scope) {
        MethodInfo method = node.getMethodInfo();
        if (!method.getGenerated().isUserDefined()) {
            return true;
        }
        this.checkAndAddReferenceRelationshipWithoutField(method.getReturnType(), node.getReturnTypeRef(), node.getLoc());
        for (Parameter parameter : method.getParameters()) {
            this.checkAndAddReferenceRelationshipWithoutField(parameter.getType(), parameter.getTypeRef(), node.getLoc());
        }
        return true;
    }

    static enum ReferencedFromTriggerDecl {
        YES,
        NO;

    }
}

