/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.WhenCase;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.statement.SwitchStatement;
import apex.jorje.semantic.ast.statement.WhenCase;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.variable.ConstantValue;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.VariableValidateLoadVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.visibility.VisibleApiVersionUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreLists;
import java.util.List;

public class WhenCases {
    private WhenCases() {
    }

    public static WhenCase create(final SwitchStatement switchStatement, apex.jorje.data.ast.WhenCase whenCase) {
        return whenCase.match(new WhenCase.MatchBlock<WhenCase>(){

            @Override
            public WhenCase _case(WhenCase.EnumCase x) {
                return new IdentifierCase(switchStatement, x.identifiers);
            }

            @Override
            public WhenCase _case(WhenCase.LiteralCase x) {
                return new LiteralCase(switchStatement, x.expr);
            }
        });
    }

    private static Object toStringAsNull(Object literalValue) {
        return literalValue == null ? null : String.valueOf(literalValue);
    }

    public static class IdentifierCase
    implements WhenCase {
        private final SwitchStatement switchStatement;
        private final List<Identifier> identifiers;
        private final Identifier lastIdentifier;
        private Object literalOrEnumName;
        private FieldInfo field;

        IdentifierCase(SwitchStatement switchStatement, List<Identifier> identifiers) {
            this.switchStatement = switchStatement;
            this.identifiers = identifiers;
            this.lastIdentifier = Iterables.getLast(identifiers);
        }

        public FieldInfo getFieldInfo() {
            return this.field;
        }

        @Override
        public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
            visitor.visit(this, scope);
            visitor.visitEnd(this, scope);
        }

        @Override
        public Object getValue() {
            return WhenCases.toStringAsNull(this.literalOrEnumName);
        }

        @Override
        public void validate(SymbolResolver symbols, ValidationScope scope) {
            TypeInfo switchType = this.switchStatement.getExpressionType();
            Errors errors = scope.getErrors();
            TypeInfo qualifiedType = this.identifiers.size() <= 1 ? (switchType.getUnitType() == UnitType.ENUM ? switchType : this.getDefiningType()) : symbols.lookupTypeInfoIdentifiers(this.getDefiningType(), MoreLists.removeLast(this.identifiers), ReferenceType.LOAD);
            this.field = qualifiedType.fields().get(symbols, this.getDefiningType(), this.lastIdentifier.getValue(), FieldTable.LookupMode.STATIC_VARIABLE);
            if (this.field == null) {
                errors.markInvalid((AstNode)this, I18nSupport.getLabel("variable.does.not.exist", this.lastIdentifier.getValue()));
                return;
            }
            if (this.field.getType().isResolved()) {
                scope.getErrors().addIfError((AstNode)this, this.getLoc(), VisibleApiVersionUtil.checkApiVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.field.getName(), this.field.getModifiers(), this.field.getMemberType()));
            }
            VariableVisitor.Context context = new VariableVisitor.Context(this.lastIdentifier.getLoc());
            VariableValidateLoadVisitor visitor = VariableValidateLoadVisitor.create(symbols, scope, this);
            if (!this.field.accept(visitor, context).booleanValue()) {
                return;
            }
            if (qualifiedType.getUnitType() != UnitType.ENUM) {
                if (!symbols.getAccessEvaluator().allowIdentifiersInSwitch()) {
                    errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.switch.enum", this.field.getName()));
                    return;
                }
                this.literalOrEnumName = this.field.getValue();
                if (!this.field.getModifiers().all(ModifierTypeInfos.STATIC, ModifierTypeInfos.FINAL)) {
                    errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.when.field.constant", this.field.getName()));
                }
                if (this.literalOrEnumName == null) {
                    errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.when.field.literal", this.field.getName()));
                }
            } else {
                if (this.identifiers.size() > 1) {
                    errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.fully.qualified.enum"));
                }
                this.literalOrEnumName = this.field.getName();
            }
        }

        @Override
        public void emit(Emitter emitter) {
            emitter.emitField(this.lastIdentifier.getLoc(), 178, this.field);
        }

        @Override
        public TypeInfo getDefiningType() {
            return this.switchStatement.getDefiningType();
        }

        @Override
        public Location getLoc() {
            return this.lastIdentifier.getLoc();
        }

        @Override
        public TypeInfo getType() {
            return this.switchStatement.getExpressionType();
        }
    }

    public static class LiteralCase
    implements WhenCase {
        private final SwitchStatement switchStatement;
        private final Expression expression;
        private final Object literalValue;

        LiteralCase(SwitchStatement switchStatement, Expr expr) {
            this.switchStatement = switchStatement;
            this.expression = AstNodes.get().create((AstNode)switchStatement, expr);
            this.literalValue = ConstantValue.get(expr);
        }

        @Override
        public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
            if (visitor.visit(this, scope)) {
                this.expression.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }

        @Override
        public Location getLoc() {
            return this.expression.getLoc();
        }

        @Override
        public TypeInfo getType() {
            return this.expression.getType();
        }

        @Override
        public void validate(SymbolResolver symbols, final ValidationScope scope) {
            this.expression.validate(symbols, scope);
            this.expression.traverse(new AstVisitor<ValidationScope>(){

                @Override
                protected boolean defaultVisit() {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("when.clause.literal.or.valid.constant"));
                    return false;
                }

                @Override
                public boolean visit(LiteralExpression node, ValidationScope scope2) {
                    return false;
                }

                @Override
                public boolean visit(PrefixExpression node, ValidationScope scope2) {
                    if (literalValue == null) {
                        this.defaultVisit();
                    }
                    return false;
                }
            }, scope);
        }

        @Override
        public void emit(Emitter emitter) {
            this.expression.emit(emitter);
        }

        @Override
        public TypeInfo getDefiningType() {
            return this.switchStatement.getDefiningType();
        }

        @Override
        public Object getValue() {
            return WhenCases.toStringAsNull(this.literalValue);
        }
    }
}

