/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.rename;

import apex.common.base.Result;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.references.ReferenceLocationProvider;
import apex.jorje.lsp.api.rename.RenameHandler;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.api.workspace.DependentCompilationTracker;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.rename.RenameUtil;
import apex.jorje.lsp.impl.visitors.InnerUserClassScope;
import apex.jorje.lsp.impl.visitors.MethodNameConflictScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.parser.ParserEngine;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureEquivalence;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.details.CodeUnitDetailsProvider;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Sets;
import com.google.inject.Provider;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodRenameHandler
implements RenameHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodRenameHandler.class);
    private final MethodInfo method;
    private final RenameParams renameParams;
    private final Signature newMethodSignature;
    private final ApexCompilerService compilerService;
    private final Provider<ApexIndex> apexIndexProvider;
    private final ReferenceLocationProvider referenceLocationProvider;
    private final ApexDocumentService documentService;
    private final VisitorFactory visitorFactory;
    private final DependentCompilationTracker dependentCompilationTracker;

    MethodRenameHandler(MethodInfo method, RenameParams renameParams, ApexCompilerService compilerService, Provider<ApexIndex> apexIndexProvider, ReferenceLocationProvider referenceLocationProvider, ApexDocumentService documentService, VisitorFactory visitorFactory, DependentCompilationTracker dependentCompilationTracker) {
        this.method = method;
        this.renameParams = renameParams;
        this.compilerService = compilerService;
        this.apexIndexProvider = apexIndexProvider;
        this.referenceLocationProvider = referenceLocationProvider;
        this.documentService = documentService;
        this.visitorFactory = visitorFactory;
        this.dependentCompilationTracker = dependentCompilationTracker;
        this.newMethodSignature = SignatureFactory.create(renameParams.getNewName(), method.getDefiningType(), method.getReturnType(), method.getParameterTypes());
    }

    @Override
    public List<Either<TextDocumentEdit, ResourceOperation>> getDocumentChanges() {
        List<Location> methodReferenceLocations = this.method.getModifiers().has(ModifierTypeInfos.STATIC) ? this.referenceLocationProvider.getReferenceLocations((ApexIndex)this.apexIndexProvider.get(), this.method) : this.referenceLocationProvider.getInstanceMethodLocations(this.apexIndexProvider, this.compilerService, this.method);
        Map<String, List<Location>> uriToLocations = methodReferenceLocations.stream().collect(Collectors.groupingBy(Location::getUri));
        List<Document> sourceDocuments = uriToLocations.keySet().stream().map(u -> this.documentService.retrieve(URI.create(u))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List<CodeUnit> codeUnits = this.compilerService.compile(sourceDocuments, ParserEngine.HiddenTokenBehavior.IGNORE);
        Map<String, CodeUnit> uriToCodeUnit = RenameUtil.getUriToCodeUnitMap(sourceDocuments, codeUnits);
        Map<String, Document> uriToSourceDocument = sourceDocuments.stream().collect(Collectors.toMap(doc -> doc.getUri().toString(), doc -> doc));
        ArrayList<Either<TextDocumentEdit, ResourceOperation>> documentChanges = new ArrayList<Either<TextDocumentEdit, ResourceOperation>>();
        for (Map.Entry<String, List<Location>> entry : uriToLocations.entrySet()) {
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            for (Location loc : entry.getValue()) {
                try {
                    int lineOffset = uriToSourceDocument.get(entry.getKey()).getLineOffset(loc.getRange().getStart().getLine());
                    int offset = lineOffset + loc.getRange().getStart().getCharacter();
                    MethodNameConflictScope methodNameConflictScope = new MethodNameConflictScope(this.newMethodSignature, offset);
                    uriToCodeUnit.get(entry.getKey()).getNode().traverse(this.visitorFactory.createMethodNameConflictVisitor(), methodNameConflictScope);
                    String newText = methodNameConflictScope.getInnerClassHavingConflict().isPresent() && !RenameUtil.isFullyQualifiedReference(methodNameConflictScope.getInnerClassHavingConflict().get(), offset) ? RenameUtil.getFullyQualifiedName(this.method, this.renameParams.getNewName()) : this.renameParams.getNewName();
                    edits.add(new TextEdit(loc.getRange(), newText));
                }
                catch (BadLocationException exception) {
                    logger.error("Encountered a bad location while providing rename", (Throwable)exception);
                }
            }
            if (TypeInfoUtil.isInnerType(this.method.getDefiningType()) && TypeInfoEquivalence.isEquivalent(this.method.getDefiningType().getEnclosingType(), uriToCodeUnit.get(entry.getKey()).getType()) && this.method.getDefiningType().getEnclosingType().methods().all().stream().filter(m -> m.getModifiers().has(ModifierTypeInfos.STATIC)).map(MethodInfo::getSignature).anyMatch(s -> SignatureEquivalence.isEquivalent(s, this.newMethodSignature))) {
                InnerUserClassScope innerUserClassScope = new InnerUserClassScope(this.method.getDefiningType());
                uriToCodeUnit.get(entry.getKey()).getNode().traverse(this.visitorFactory.createInnerUserClassVisitor(), innerUserClassScope);
                edits.addAll(RenameUtil.methodNameRewrites(innerUserClassScope.getUserClass(), this.newMethodSignature));
            }
            documentChanges.add((Either<TextDocumentEdit, ResourceOperation>)Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(entry.getKey(), null), edits)));
        }
        RenameUtil.addDependentCompilation(this.dependentCompilationTracker, this.method.getDefiningType().getCodeUnitDetails().getSource().getKnownName(), uriToLocations.keySet());
        return documentChanges;
    }

    @Override
    public Optional<String> getConflictError() {
        if (this.renameParams.getNewName().equalsIgnoreCase(this.method.getName())) {
            return Optional.empty();
        }
        return this.getMethodRenameConflictError(this.compilerService.getSymbolResolver(), this.apexIndexProvider, this.newMethodSignature, this.method);
    }

    @Override
    public Optional<String> canBeRenamed() {
        return CodeUnitDetailsProvider.isUserSourced(this.method.getDefiningType().getCodeUnitDetails()) ? Optional.empty() : Optional.of(I18nSupport.getLabel("cannot.rename"));
    }

    @Override
    public Optional<String> isIdentifierNameInvalid() {
        Result<Void> validationResult = IdentifierValidator.get().validate(this.method.getDefiningType(), this.renameParams.getNewName(), IdentifierValidator.Type.METHOD, false, false);
        if (validationResult.hasError()) {
            return Optional.of(validationResult.getError());
        }
        return Optional.empty();
    }

    private Optional<String> getMethodRenameConflictError(SymbolResolver symbols, Provider<ApexIndex> apexIndexProvider, Signature signature, MethodInfo method) {
        if (method.getDefiningType().methods().all().stream().map(MethodInfo::getSignature).anyMatch(s -> SignatureEquivalence.isEquivalent(s, signature))) {
            return Optional.of(I18nSupport.getLabel("new.name.member.conflict", method.getDefiningType().getApexName()));
        }
        Optional<TypeInfo> ancestorType = this.getAncestorTypeHavingMethodConflict(apexIndexProvider, symbols, signature, method.getDefiningType());
        if (ancestorType.isPresent()) {
            return Optional.of(I18nSupport.getLabel("new.name.member.conflict", ancestorType.get().getApexName()));
        }
        Optional<TypeInfo> descendantType = this.getDescendantTypeHavingMethodConflict(apexIndexProvider, symbols, signature, method.getDefiningType());
        if (!method.getModifiers().has(ModifierTypeInfos.PRIVATE) && descendantType.isPresent()) {
            return Optional.of(I18nSupport.getLabel("new.name.member.conflict", descendantType.get().getApexName()));
        }
        return Optional.empty();
    }

    private Optional<TypeInfo> getDescendantTypeHavingMethodConflict(Provider<ApexIndex> apexIndexProvider, SymbolResolver symbols, Signature signature, TypeInfo typeInfo) {
        ApexIndex apexIndex = (ApexIndex)apexIndexProvider.get();
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            ApexTypeId apexId = apexIndex.findExactTypeId(typeInfo.getApexName());
            Optional<TypeInfo> optional = this.findDescendantTypeHavingMethodConflict(apexIndexProvider, symbols, signature, apexId.getChildren(), new HashSet<String>());
            return optional;
        }
    }

    private Optional<TypeInfo> findDescendantTypeHavingMethodConflict(Provider<ApexIndex> apexIndexProvider, SymbolResolver symbols, Signature signature, List<ApexTypeId> children, HashSet<String> visitedTypes) {
        for (ApexTypeId childId : children) {
            TypeInfo apexTypeInfo = RenameUtil.getTypeInfo(apexIndexProvider, symbols, childId);
            if (apexTypeInfo.methods().all().stream().map(MethodInfo::getSignature).anyMatch(s -> SignatureEquivalence.isEquivalent(s, signature))) {
                return Optional.of(apexTypeInfo);
            }
            if (visitedTypes.contains(apexTypeInfo.getApexName())) continue;
            return this.findDescendantTypeHavingMethodConflict(apexIndexProvider, symbols, signature, childId.getChildren(), visitedTypes);
        }
        return Optional.empty();
    }

    private Optional<TypeInfo> getAncestorTypeHavingMethodConflict(Provider<ApexIndex> apexIndexProvider, SymbolResolver symbols, Signature signature, TypeInfo typeInfo) {
        ApexIndex apexIndex = (ApexIndex)apexIndexProvider.get();
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            ApexTypeId apexId = apexIndex.findExactTypeId(typeInfo.getApexName());
            Optional<TypeInfo> optional = this.findAncestorTypeHavingMethodConflict(apexIndexProvider, symbols, signature, apexId.getParent(), Sets.newHashSet("Object", "System.ApexBaseClass"));
            return optional;
        }
    }

    private Optional<TypeInfo> findAncestorTypeHavingMethodConflict(Provider<ApexIndex> apexIndexProvider, SymbolResolver symbols, Signature signature, ApexTypeId apexId, HashSet<String> visitedTypes) {
        TypeInfo apexTypeInfo = RenameUtil.getTypeInfo(apexIndexProvider, symbols, apexId);
        visitedTypes.add(apexId.getApexName().getString());
        if (apexTypeInfo.methods().all().stream().filter(m -> !m.getModifiers().has(ModifierTypeInfos.PRIVATE)).map(MethodInfo::getSignature).anyMatch(s -> SignatureEquivalence.isEquivalent(s, signature))) {
            return Optional.of(apexTypeInfo);
        }
        if (apexId.getParent() != null && !visitedTypes.contains(apexId.getParent().getApexName().getString())) {
            return this.findAncestorTypeHavingMethodConflict(apexIndexProvider, symbols, signature, apexId.getParent(), visitedTypes);
        }
        return Optional.empty();
    }
}

